/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.osgeo.proj4j.datum.Grid;
import org.osgeo.proj4j.util.FloatPolarCoordinate;
import org.osgeo.proj4j.util.IntPolarCoordinate;
import org.osgeo.proj4j.util.PolarCoordinate;

public final class NTV1 {
    private static final byte[] magic1 = "HEADER".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] magic2 = "W GRID".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] magic3 = "TO      NAD83   ".getBytes(StandardCharsets.US_ASCII);

    private NTV1() {
    }

    public static boolean testHeader(byte[] byArray) {
        return NTV1.containsAt(magic1, byArray, 0) && NTV1.containsAt(magic2, byArray, 96) && NTV1.containsAt(magic3, byArray, 144);
    }

    public static Grid.ConversionTable init(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[160];
        dataInputStream.readFully(byArray);
        if (!NTV1.testHeader(byArray)) {
            throw new Error("Not a NTV1 file");
        }
        int n = NTV1.intFromBytes(byArray, 8);
        if (n != 12) {
            throw new Error(String.format("NTv1 grid shift file has wrong record count, corrupt? $0%08X $0", n));
        }
        Grid.ConversionTable conversionTable = new Grid.ConversionTable();
        conversionTable.id = "NTv1 Grid Shift File";
        conversionTable.ll = new PolarCoordinate(-NTV1.doubleFromBytes(byArray, 72), NTV1.doubleFromBytes(byArray, 24));
        PolarCoordinate polarCoordinate = new PolarCoordinate(-NTV1.doubleFromBytes(byArray, 56), NTV1.doubleFromBytes(byArray, 40));
        conversionTable.del = new PolarCoordinate(NTV1.doubleFromBytes(byArray, 104), NTV1.doubleFromBytes(byArray, 88));
        conversionTable.lim = new IntPolarCoordinate((int)(Math.abs(polarCoordinate.lam - conversionTable.ll.lam) / conversionTable.del.lam + 0.5) + 1, (int)(Math.abs(polarCoordinate.phi - conversionTable.ll.phi) / conversionTable.del.phi + 0.5) + 1);
        conversionTable.ll.lam *= Math.PI / 180;
        conversionTable.ll.phi *= Math.PI / 180;
        conversionTable.del.lam *= Math.PI / 180;
        conversionTable.del.phi *= Math.PI / 180;
        return conversionTable;
    }

    public static void load(DataInputStream dataInputStream, Grid grid) throws IOException {
        dataInputStream.skip(176L);
        double[] dArray = new double[grid.table.lim.lam * 2];
        FloatPolarCoordinate[] floatPolarCoordinateArray = new FloatPolarCoordinate[grid.table.lim.lam * grid.table.lim.phi];
        for (int i = 0; i < grid.table.lim.phi; ++i) {
            byte[] byArray = new byte[8 * dArray.length];
            dataInputStream.readFully(byArray);
            ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).asDoubleBuffer().get(dArray);
            for (int j = 0; j < grid.table.lim.lam; ++j) {
                floatPolarCoordinateArray[i * grid.table.lim.lam + grid.table.lim.lam - j - 1] = new FloatPolarCoordinate((float)(dArray[2 * j] * Math.PI / 180.0 / 3600.0), (float)(dArray[2 * j + 1] * Math.PI / 180.0 / 3600.0));
            }
        }
        grid.table.cvs = floatPolarCoordinateArray;
    }

    private static boolean containsAt(byte[] byArray, byte[] byArray2, int n) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n2 = Math.min(byArray.length - 1, byArray2.length - n - 1);
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }

    private static double doubleFromBytes(byte[] byArray, int n) {
        return ByteBuffer.wrap(byArray, n, 8).order(ByteOrder.BIG_ENDIAN).getDouble();
    }

    private static int intFromBytes(byte[] byArray, int n) {
        return ByteBuffer.wrap(byArray, n, 4).order(ByteOrder.BIG_ENDIAN).getInt();
    }
}

