/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.CTABLEV2;
import org.osgeo.proj4j.datum.NTV1;
import org.osgeo.proj4j.util.FloatPolarCoordinate;
import org.osgeo.proj4j.util.IntPolarCoordinate;
import org.osgeo.proj4j.util.PolarCoordinate;
import org.osgeo.proj4j.util.ProjectionMath;

public final class Grid
implements Serializable {
    private String gridName;
    private String fileName;
    private String format;
    private int gridOffset;
    static final int MAX_TRY = 9;
    static final double TOL = 1.0E-12;
    ConversionTable table;
    private Grid next;
    private Grid child;

    public static void mergeGridFile(String string, List<Grid> list) throws IOException {
        list.add(Grid.gridinfoInit(string));
    }

    public static void shift(List<Grid> list, boolean bl, ProjCoordinate projCoordinate) {
        PolarCoordinate polarCoordinate = new PolarCoordinate(projCoordinate.x, projCoordinate.y);
        PolarCoordinate polarCoordinate2 = new PolarCoordinate(Double.NaN, Double.NaN);
        for (Grid grid : list) {
            ConversionTable conversionTable = grid.table;
            double d = (Math.abs(conversionTable.del.phi) + Math.abs(conversionTable.del.lam)) / 10000.0;
            if (conversionTable.ll.phi - d > polarCoordinate.phi || conversionTable.ll.lam - d > polarCoordinate.lam || conversionTable.ll.phi + (double)(conversionTable.lim.phi - 1) * conversionTable.del.phi + d < polarCoordinate.phi || conversionTable.ll.lam + (double)(conversionTable.lim.lam - 1) * conversionTable.del.lam + d < polarCoordinate.lam) continue;
            while (grid.child != null) {
                Grid grid2 = grid.child;
                while (grid2 != null) {
                    ConversionTable conversionTable2 = grid2.table;
                    double d2 = (Math.abs(conversionTable2.del.phi) + Math.abs(conversionTable2.del.lam)) / 10000.0;
                    if (!(conversionTable2.ll.phi - d2 > polarCoordinate.phi || conversionTable2.ll.lam - d2 > polarCoordinate.lam || conversionTable2.ll.phi + (double)(conversionTable2.lim.phi - 1) * conversionTable2.del.phi + d2 < polarCoordinate.phi) && !(conversionTable2.ll.lam + (double)(conversionTable2.lim.lam - 1) * conversionTable2.del.lam + d2 < polarCoordinate.lam)) break;
                    grid2 = grid2.next;
                }
                if (grid2 == null) break;
                grid = grid2;
            }
            if (grid.table.cvs == null) {
                // empty if block
            }
            polarCoordinate2 = Grid.nad_cvt(polarCoordinate, bl, conversionTable);
        }
        if (!Double.isNaN(polarCoordinate2.lam)) {
            projCoordinate.x = polarCoordinate2.lam;
            projCoordinate.y = polarCoordinate2.phi;
        }
    }

    private static PolarCoordinate nad_cvt(PolarCoordinate polarCoordinate, boolean bl, ConversionTable conversionTable) {
        if (Double.isNaN(polarCoordinate.lam)) {
            return polarCoordinate;
        }
        PolarCoordinate polarCoordinate2 = new PolarCoordinate(polarCoordinate);
        polarCoordinate2.lam -= conversionTable.ll.lam;
        polarCoordinate2.phi -= conversionTable.ll.phi;
        polarCoordinate2.lam = ProjectionMath.normalizeLongitude(polarCoordinate2.lam - Math.PI) + Math.PI;
        PolarCoordinate polarCoordinate3 = Grid.nad_intr(polarCoordinate2, conversionTable);
        if (bl) {
            PolarCoordinate polarCoordinate4 = new PolarCoordinate(Double.NaN, Double.NaN);
            PolarCoordinate polarCoordinate5 = new PolarCoordinate(Double.NaN, Double.NaN);
            int n = 9;
            if (Double.isNaN(polarCoordinate3.lam)) {
                return polarCoordinate3;
            }
            polarCoordinate3.lam = polarCoordinate2.lam + polarCoordinate3.lam;
            polarCoordinate3.phi = polarCoordinate2.phi - polarCoordinate3.phi;
            do {
                polarCoordinate4 = Grid.nad_intr(polarCoordinate3, conversionTable);
                if (Double.isNaN(polarCoordinate4.lam)) break;
                polarCoordinate5.lam = polarCoordinate3.lam - polarCoordinate4.lam - polarCoordinate2.lam;
                polarCoordinate3.lam -= polarCoordinate5.lam;
                polarCoordinate5.phi = polarCoordinate3.phi + polarCoordinate4.phi - polarCoordinate2.phi;
                polarCoordinate3.phi -= polarCoordinate5.phi;
            } while (n-- > 0 && Math.abs(polarCoordinate5.lam) > 1.0E-12 && Math.abs(polarCoordinate5.phi) > 1.0E-12);
            if (n < 0) {
                polarCoordinate3.phi = Double.NaN;
                polarCoordinate3.lam = Double.NaN;
                return polarCoordinate3;
            }
            polarCoordinate.lam = ProjectionMath.normalizeLongitude(polarCoordinate3.lam + conversionTable.ll.lam);
            polarCoordinate.phi = polarCoordinate3.phi + conversionTable.ll.phi;
        } else if (Double.isNaN(polarCoordinate3.lam)) {
            polarCoordinate = polarCoordinate3;
        } else {
            polarCoordinate.lam -= polarCoordinate3.lam;
            polarCoordinate.phi += polarCoordinate3.phi;
        }
        return polarCoordinate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PolarCoordinate nad_intr(PolarCoordinate polarCoordinate, ConversionTable conversionTable) {
        double d;
        double d2;
        int n;
        polarCoordinate = new PolarCoordinate(polarCoordinate);
        PolarCoordinate polarCoordinate2 = new PolarCoordinate(Double.NaN, Double.NaN);
        IntPolarCoordinate intPolarCoordinate = new IntPolarCoordinate((int)Math.floor(polarCoordinate.lam /= conversionTable.del.lam), (int)Math.floor(polarCoordinate.phi /= conversionTable.del.phi));
        PolarCoordinate polarCoordinate3 = new PolarCoordinate(polarCoordinate.lam - (double)intPolarCoordinate.lam, polarCoordinate.phi - (double)intPolarCoordinate.phi);
        if (intPolarCoordinate.lam < 0) {
            if (intPolarCoordinate.lam != -1 || !(polarCoordinate3.lam > 0.99999999999)) return polarCoordinate2;
            ++intPolarCoordinate.lam;
            polarCoordinate3.lam = 0.0;
        } else {
            n = intPolarCoordinate.lam + 1;
            if (n >= conversionTable.lim.lam) {
                if (n != conversionTable.lim.lam || !(polarCoordinate3.lam < 1.0E-11)) return polarCoordinate2;
                --intPolarCoordinate.lam;
                polarCoordinate3.lam = 1.0;
            }
        }
        if (intPolarCoordinate.phi < 0) {
            if (intPolarCoordinate.phi != -1 || !(polarCoordinate3.phi > 0.99999999999)) return polarCoordinate2;
            ++intPolarCoordinate.phi;
            polarCoordinate3.phi = 0.0;
        } else {
            n = intPolarCoordinate.phi + 1;
            if (n >= conversionTable.lim.phi) {
                if (n != conversionTable.lim.phi || !(polarCoordinate3.phi < 1.0E-11)) return polarCoordinate2;
                --intPolarCoordinate.phi;
                polarCoordinate3.phi = 1.0;
            }
        }
        int n2 = intPolarCoordinate.phi * conversionTable.lim.lam + intPolarCoordinate.lam;
        FloatPolarCoordinate floatPolarCoordinate = conversionTable.cvs[n2++];
        FloatPolarCoordinate floatPolarCoordinate2 = conversionTable.cvs[n2];
        n2 += conversionTable.lim.lam;
        FloatPolarCoordinate floatPolarCoordinate3 = conversionTable.cvs[n2--];
        FloatPolarCoordinate floatPolarCoordinate4 = conversionTable.cvs[n2];
        double d3 = d2 = polarCoordinate3.lam;
        double d4 = d = 1.0 - polarCoordinate3.lam;
        polarCoordinate2.lam = d4 * (double)floatPolarCoordinate.lam + d2 * (double)floatPolarCoordinate2.lam + (d *= polarCoordinate3.phi) * (double)floatPolarCoordinate4.lam + (d3 *= polarCoordinate3.phi) * (double)floatPolarCoordinate3.lam;
        polarCoordinate2.phi = d4 * (double)floatPolarCoordinate.phi + d2 * (double)floatPolarCoordinate2.phi + d * (double)floatPolarCoordinate4.phi + d3 * (double)floatPolarCoordinate3.phi;
        return polarCoordinate2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Grid> fromNadGrids(String string) throws IOException {
        ArrayList<Grid> arrayList = new ArrayList<Grid>();
        Class<Grid> clazz = Grid.class;
        synchronized (Grid.class) {
            for (String string2 : string.split(",")) {
                boolean bl = string2.startsWith("@");
                if (bl) {
                    string2 = string2.substring(1);
                }
                try {
                    Grid.mergeGridFile(string2, arrayList);
                }
                catch (IOException iOException) {
                    if (bl) continue;
                    throw iOException;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return arrayList;
        }
    }

    private static Grid gridinfoInit(String string) throws IOException {
        Grid grid = new Grid();
        grid.gridName = string;
        grid.format = "missing";
        grid.gridOffset = 0;
        DataInputStream dataInputStream = Grid.resolveGridDefinition(string);
        if (dataInputStream == null) {
            throw new IOException("Unknown grid: " + string);
        }
        byte[] byArray = new byte[160];
        dataInputStream.mark(byArray.length);
        dataInputStream.readFully(byArray);
        dataInputStream.reset();
        if (CTABLEV2.testHeader(byArray)) {
            grid.format = "ctable2";
            dataInputStream.mark(1024);
            grid.table = CTABLEV2.init(dataInputStream);
            dataInputStream.reset();
            CTABLEV2.load(dataInputStream, grid);
        }
        if (NTV1.testHeader(byArray)) {
            grid.format = "ntv1";
            dataInputStream.mark(1024);
            grid.table = NTV1.init(dataInputStream);
            dataInputStream.reset();
            NTV1.load(dataInputStream, grid);
        }
        return grid;
    }

    private static DataInputStream resolveGridDefinition(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            return new DataInputStream(new FileInputStream(file));
        }
        InputStream inputStream = Grid.class.getResourceAsStream("/geotrellis/proj4/nad/" + string);
        if (inputStream != null) {
            return new DataInputStream(inputStream);
        }
        return null;
    }

    public int hashCode() {
        int n = this.gridName == null ? 0 : this.gridName.hashCode();
        int n2 = this.fileName == null ? 0 : this.fileName.hashCode();
        int n3 = this.format == null ? 0 : this.format.hashCode();
        int n4 = this.table == null ? 0 : this.table.hashCode();
        int n5 = this.next == null ? 0 : this.next.hashCode();
        int n6 = this.next == null ? 0 : this.next.hashCode();
        return n | 7 * n2 | 11 * n3 | 17 * n4 | 23 * n5 | 31 * n6;
    }

    public boolean equals(Object object) {
        if (object instanceof Grid) {
            Grid grid = (Grid)object;
            if (this.gridName == null && grid.gridName != null) {
                return false;
            }
            if (!this.gridName.equals(grid.gridName)) {
                return false;
            }
            if (this.fileName == null && grid.fileName != null) {
                return false;
            }
            if (!this.fileName.equals(grid.fileName)) {
                return false;
            }
            if (this.format == null && grid.format != null) {
                return false;
            }
            if (!this.format.equals(grid.format)) {
                return false;
            }
            if (this.table == null && grid.table != null) {
                return false;
            }
            if (!this.table.equals(grid.table)) {
                return false;
            }
            if (this.next == null && grid.next != null) {
                return false;
            }
            if (!this.next.equals(grid.next)) {
                return false;
            }
            if (this.child == null && grid.child != null) {
                return false;
            }
            return this.child.equals(grid.child);
        }
        return false;
    }

    public String toString() {
        return "Grid[" + this.gridName + "; " + this.format + "]";
    }

    public static final class ConversionTable
    implements Serializable {
        public String id;
        public PolarCoordinate del;
        public PolarCoordinate ll;
        public IntPolarCoordinate lim;
        public FloatPolarCoordinate[] cvs;

        public String toString() {
            return String.format("Grid: %s", this.id);
        }

        public int hashCode() {
            int n = this.id == null ? 0 : this.id.hashCode();
            int n2 = this.del == null ? 0 : this.del.hashCode();
            int n3 = this.ll == null ? 0 : this.ll.hashCode();
            int n4 = Arrays.hashCode(this.cvs);
            return n | 11 * n2 | 23 * n3 | 37 * n4;
        }

        public boolean equals(Object object) {
            if (object instanceof ConversionTable) {
                ConversionTable conversionTable = (ConversionTable)object;
                if (this.id == null && conversionTable.id != null) {
                    return false;
                }
                if (!this.id.equals(conversionTable.id)) {
                    return false;
                }
                if (this.del == null && conversionTable.del != null) {
                    return false;
                }
                if (!this.del.equals(conversionTable.del)) {
                    return false;
                }
                if (this.ll == null && conversionTable.ll != null) {
                    return false;
                }
                if (!this.ll.equals(conversionTable.ll)) {
                    return false;
                }
                return Arrays.equals(this.cvs, conversionTable.cvs);
            }
            return false;
        }
    }
}

