/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import java.io.Serializable;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.Ellipsoid;

public class GeocentricConverter
implements Serializable {
    double a;
    double b;
    double a2;
    double b2;
    double e2;
    double ep2;

    public GeocentricConverter(Ellipsoid ellipsoid) {
        this(ellipsoid.getA(), ellipsoid.getB());
    }

    public GeocentricConverter(double d, double d2) {
        this.a = d;
        this.b = d2;
        this.a2 = d * d;
        this.b2 = d2 * d2;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
    }

    public void overrideWithWGS84Params() {
        this.a = Ellipsoid.WGS84.getA();
        this.e2 = Ellipsoid.WGS84.getEccentricitySquared();
    }

    public void convertGeodeticToGeocentric(ProjCoordinate projCoordinate) {
        double d;
        double d2 = projCoordinate.x;
        double d3 = projCoordinate.y;
        double d4 = d = projCoordinate.hasValidZOrdinate() ? projCoordinate.z : 0.0;
        if (d3 < -1.5707963267948966 && d3 > -1.5723671231216914) {
            d3 = -1.5707963267948966;
        } else if (d3 > 1.5707963267948966 && d3 < 1.5723671231216914) {
            d3 = 1.5707963267948966;
        } else if (d3 < -1.5707963267948966 || d3 > 1.5707963267948966) {
            throw new IllegalStateException("Latitude is out of range: " + d3);
        }
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = d5 * d5;
        double d8 = this.a / Math.sqrt(1.0 - this.e2 * d7);
        double d9 = (d8 + d) * d6 * Math.cos(d2);
        double d10 = (d8 + d) * d6 * Math.sin(d2);
        double d11 = (d8 * (1.0 - this.e2) + d) * d5;
        projCoordinate.x = d9;
        projCoordinate.y = d10;
        projCoordinate.z = d11;
    }

    public void convertGeocentricToGeodetic(ProjCoordinate projCoordinate) {
        this.convertGeocentricToGeodeticIter(projCoordinate);
    }

    public void convertGeocentricToGeodeticIter(ProjCoordinate projCoordinate) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = 1.0E-12;
        double d7 = d6 * d6;
        int n = 30;
        double d8 = projCoordinate.x;
        double d9 = projCoordinate.y;
        double d10 = projCoordinate.hasValidZOrdinate() ? projCoordinate.z : 0.0;
        boolean bl = false;
        double d11 = Math.sqrt(d8 * d8 + d9 * d9);
        double d12 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        if (d11 / this.a < d6) {
            bl = true;
            d5 = 0.0;
            if (d12 / this.a < d6) {
                double d13 = 1.5707963267948966;
                double d14 = -this.b;
                projCoordinate.x = d5;
                projCoordinate.y = d13;
                projCoordinate.z = d14;
                return;
            }
        } else {
            d5 = Math.atan2(d9, d8);
        }
        double d15 = d10 / d12;
        double d16 = d11 / d12;
        double d17 = 1.0 / Math.sqrt(1.0 - this.e2 * (2.0 - this.e2) * d16 * d16);
        double d18 = d16 * (1.0 - this.e2) * d17;
        double d19 = d15 * d17;
        int n2 = 0;
        do {
            ++n2;
            double d20 = this.a / Math.sqrt(1.0 - this.e2 * d19 * d19);
            d3 = d11 * d18 + d10 * d19 - d20 * (1.0 - this.e2 * d19 * d19);
            double d21 = this.e2 * d20 / (d20 + d3);
            d17 = 1.0 / Math.sqrt(1.0 - d21 * (2.0 - d21) * d16 * d16);
            d2 = d16 * (1.0 - d21) * d17;
            d = d15 * d17;
            d4 = d * d18 - d2 * d19;
            d18 = d2;
            d19 = d;
        } while (d4 * d4 > d7 && n2 < n);
        double d22 = Math.atan(d / Math.abs(d2));
        projCoordinate.x = d5;
        projCoordinate.y = d22;
        projCoordinate.z = d3;
    }
}

