/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.datum.Grid;
import org.osgeo.proj4j.util.ProjectionMath;

public class Datum
implements Serializable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_WGS84 = 1;
    public static final int TYPE_3PARAM = 2;
    public static final int TYPE_7PARAM = 3;
    public static final int TYPE_GRIDSHIFT = 4;
    private static final double[] DEFAULT_TRANSFORM = new double[]{0.0, 0.0, 0.0};
    public static final Datum WGS84 = new Datum("WGS84", 0.0, 0.0, 0.0, Ellipsoid.WGS84, "WGS84");
    public static final Datum GGRS87 = new Datum("GGRS87", -199.87, 74.79, 246.62, Ellipsoid.GRS80, "Greek_Geodetic_Reference_System_1987");
    public static final Datum NAD83 = new Datum("NAD83", 0.0, 0.0, 0.0, Ellipsoid.GRS80, "North_American_Datum_1983");
    public static final Datum NAD27;
    public static final Datum POTSDAM;
    public static final Datum CARTHAGE;
    public static final Datum HERMANNSKOGEL;
    public static final Datum IRE65;
    public static final Datum NZGD49;
    public static final Datum OSEB36;
    private String code;
    private String name;
    private Ellipsoid ellipsoid;
    private double[] transform = DEFAULT_TRANSFORM;
    private List<Grid> grids = null;
    public static final double ELLIPSOID_E2_TOLERANCE = 5.0E-11;

    private Datum(String string, List<Grid> list, Ellipsoid ellipsoid, String string2) {
        this(string, null, list, ellipsoid, string2);
    }

    public Datum(String string, double d, double d2, double d3, Ellipsoid ellipsoid, String string2) {
        this(string, new double[]{d, d2, d3}, null, ellipsoid, string2);
    }

    public Datum(String string, double d, double d2, double d3, double d4, double d5, double d6, double d7, Ellipsoid ellipsoid, String string2) {
        this(string, new double[]{d, d2, d3, d4, d5, d6, d7}, null, ellipsoid, string2);
    }

    public Datum(String string, double[] dArray, List<Grid> list, Ellipsoid ellipsoid, String string2) {
        this.code = string;
        this.name = string2;
        this.ellipsoid = ellipsoid;
        this.grids = list;
        if (dArray != null && dArray.length > 3) {
            dArray[3] = dArray[3] * 4.84813681109536E-6;
            dArray[4] = dArray[4] * 4.84813681109536E-6;
            dArray[5] = dArray[5] * 4.84813681109536E-6;
            dArray[6] = dArray[6] / 1000000.0 + 1.0;
        }
        this.transform = dArray;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[Datum-" + this.name + "]";
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public double[] getTransformToWGS84() {
        return this.transform;
    }

    public int getTransformType() {
        if (this.grids != null && this.grids.size() > 0) {
            return 4;
        }
        if (Ellipsoid.WGS84.equals(this.ellipsoid) || Ellipsoid.GRS80.equals(this.ellipsoid)) {
            if (this.transform == null) {
                return 1;
            }
            if (ProjectionMath.isIdentity(this.transform)) {
                return 1;
            }
        }
        if (this.transform == null) {
            return 0;
        }
        if (this.transform.length == 3) {
            return 2;
        }
        if (this.transform.length == 7) {
            return 3;
        }
        return 0;
    }

    public boolean hasTransformToWGS84() {
        int n = this.getTransformType();
        return n == 2 || n == 3;
    }

    public boolean isEqual(Datum datum) {
        if (this.getTransformType() != datum.getTransformType()) {
            return false;
        }
        if (this.ellipsoid.getEquatorRadius() != this.ellipsoid.getEquatorRadius() && Math.abs(this.ellipsoid.getEccentricitySquared() - datum.ellipsoid.getEccentricitySquared()) > 5.0E-11) {
            return false;
        }
        if (this.getTransformType() == 2 || this.getTransformType() == 3) {
            for (int i = 0; i < this.transform.length; ++i) {
                if (this.transform[i] == datum.transform[i]) continue;
                return false;
            }
            return true;
        }
        if (this.getTransformType() == 4) {
            return this.grids.equals(datum.grids);
        }
        return true;
    }

    public void transformFromGeocentricToWgs84(ProjCoordinate projCoordinate) {
        if (this.transform.length == 3) {
            projCoordinate.x += this.transform[0];
            projCoordinate.y += this.transform[1];
            projCoordinate.z += this.transform[2];
        } else if (this.transform.length == 7) {
            double d = this.transform[0];
            double d2 = this.transform[1];
            double d3 = this.transform[2];
            double d4 = this.transform[3];
            double d5 = this.transform[4];
            double d6 = this.transform[5];
            double d7 = this.transform[6];
            double d8 = d7 * (projCoordinate.x - d6 * projCoordinate.y + d5 * projCoordinate.z) + d;
            double d9 = d7 * (d6 * projCoordinate.x + projCoordinate.y - d4 * projCoordinate.z) + d2;
            double d10 = d7 * (-d5 * projCoordinate.x + d4 * projCoordinate.y + projCoordinate.z) + d3;
            projCoordinate.x = d8;
            projCoordinate.y = d9;
            projCoordinate.z = d10;
        }
    }

    public void transformToGeocentricFromWgs84(ProjCoordinate projCoordinate) {
        if (this.transform.length == 3) {
            projCoordinate.x -= this.transform[0];
            projCoordinate.y -= this.transform[1];
            projCoordinate.z -= this.transform[2];
        } else if (this.transform.length == 7) {
            double d = this.transform[0];
            double d2 = this.transform[1];
            double d3 = this.transform[2];
            double d4 = this.transform[3];
            double d5 = this.transform[4];
            double d6 = this.transform[5];
            double d7 = this.transform[6];
            double d8 = (projCoordinate.x - d) / d7;
            double d9 = (projCoordinate.y - d2) / d7;
            double d10 = (projCoordinate.z - d3) / d7;
            projCoordinate.x = d8 + d6 * d9 - d5 * d10;
            projCoordinate.y = -d6 * d8 + d9 + d4 * d10;
            projCoordinate.z = d5 * d8 - d4 * d9 + d10;
        }
    }

    public void shift(ProjCoordinate projCoordinate) {
        Grid.shift(this.grids, false, projCoordinate);
    }

    public void inverseShift(ProjCoordinate projCoordinate) {
        Grid.shift(this.grids, true, projCoordinate);
    }

    static {
        POTSDAM = new Datum("potsdam", 598.1, 73.7, 418.2, 0.202, 0.045, -2.455, 6.7, Ellipsoid.BESSEL, "Potsdam Rauenberg 1950 DHDN");
        CARTHAGE = new Datum("carthage", -263.0, 6.0, 431.0, Ellipsoid.CLARKE_1880, "Carthage 1934 Tunisia");
        HERMANNSKOGEL = new Datum("hermannskogel", 577.326, 90.129, 463.919, 5.137, 1.474, 5.297, 2.4232, Ellipsoid.BESSEL, "Hermannskogel");
        IRE65 = new Datum("ire65", 482.53, -130.596, 564.557, -1.042, -0.214, -0.631, 8.15, Ellipsoid.MOD_AIRY, "Ireland 1965");
        NZGD49 = new Datum("nzgd49", 59.47, -5.04, 187.44, 0.47, -0.1, 1.024, -4.5993, Ellipsoid.INTERNATIONAL, "New Zealand Geodetic Datum 1949");
        OSEB36 = new Datum("OSGB36", 446.448, -125.157, 542.06, 0.1502, 0.247, 0.8421, -20.4894, Ellipsoid.AIRY, "Airy 1830");
        Datum datum = new Datum("NAD27", new ArrayList<Grid>(), Ellipsoid.CLARKE_1866, "North_American_Datum_1927");
        try {
            datum = new Datum("NAD27", Grid.fromNadGrids("@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat"), Ellipsoid.CLARKE_1866, "North_American_Datum_1927");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NAD27 = datum;
    }
}

