/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.osgeo.proj4j.datum.Grid;
import org.osgeo.proj4j.util.FloatPolarCoordinate;
import org.osgeo.proj4j.util.IntPolarCoordinate;
import org.osgeo.proj4j.util.PolarCoordinate;

public final class CTABLEV2 {
    private static final byte[] magic = "CTABLE V2".getBytes(StandardCharsets.US_ASCII);

    private CTABLEV2() {
    }

    public static boolean testHeader(byte[] byArray) {
        return CTABLEV2.containsAt(magic, byArray, 0);
    }

    public static Grid.ConversionTable init(DataInputStream dataInputStream) throws IOException {
        int n;
        byte[] byArray = new byte[160];
        dataInputStream.readFully(byArray);
        if (!CTABLEV2.containsAt(magic, byArray, 0)) {
            throw new Error("Not a CTABLE V2 file");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 16, 96);
        PolarCoordinate polarCoordinate = new PolarCoordinate(CTABLEV2.doubleFromBytes(byArray, 96), CTABLEV2.doubleFromBytes(byArray, 104));
        PolarCoordinate polarCoordinate2 = new PolarCoordinate(CTABLEV2.doubleFromBytes(byArray, 112), CTABLEV2.doubleFromBytes(byArray, 120));
        IntPolarCoordinate intPolarCoordinate = new IntPolarCoordinate(CTABLEV2.intFromBytes(byArray, 128), CTABLEV2.intFromBytes(byArray, 132));
        if (intPolarCoordinate.lam < 1 || intPolarCoordinate.lam > 100000 || intPolarCoordinate.phi < 1 || intPolarCoordinate.phi > 100000) {
            throw new Error("Grid position counts outside of acceptable parameters for CTABLE file " + intPolarCoordinate);
        }
        for (n = 0; n < byArray2.length && byArray2[n] != 0; ++n) {
        }
        Grid.ConversionTable conversionTable = new Grid.ConversionTable();
        conversionTable.id = new String(byArray2, 0, n, StandardCharsets.US_ASCII).trim();
        conversionTable.ll = polarCoordinate;
        conversionTable.del = polarCoordinate2;
        conversionTable.lim = intPolarCoordinate;
        return conversionTable;
    }

    public static void load(DataInputStream dataInputStream, Grid grid) throws IOException {
        Grid.ConversionTable conversionTable = grid.table;
        int n = conversionTable.lim.lam * conversionTable.lim.phi;
        FloatPolarCoordinate[] floatPolarCoordinateArray = new FloatPolarCoordinate[n];
        byte[] byArray = new byte[8];
        dataInputStream.skipBytes(160);
        for (int i = 0; i < n; ++i) {
            dataInputStream.readFully(byArray);
            floatPolarCoordinateArray[i] = new FloatPolarCoordinate(CTABLEV2.floatFromBytes(byArray, 0), CTABLEV2.floatFromBytes(byArray, 4));
        }
        conversionTable.cvs = floatPolarCoordinateArray;
    }

    private static boolean containsAt(byte[] byArray, byte[] byArray2, int n) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n2 = Math.min(byArray.length - 1, byArray2.length - n - 1);
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }

    private static double doubleFromBytes(byte[] byArray, int n) {
        return ByteBuffer.wrap(byArray, n, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    private static int intFromBytes(byte[] byArray, int n) {
        return ByteBuffer.wrap(byArray, n, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private static float floatFromBytes(byte[] byArray, int n) {
        return ByteBuffer.wrap(byArray, n, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }
}

