/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import java.io.Serializable;
import org.osgeo.proj4j.ProjCoordinate;

public final class AxisOrder
implements Serializable {
    public static final AxisOrder ENU = new AxisOrder(Axis.Easting, Axis.Northing, Axis.Up);
    private final Axis x;
    private final Axis y;
    private final Axis z;

    private AxisOrder(Axis axis, Axis axis2, Axis axis3) {
        this.x = axis;
        this.y = axis2;
        this.z = axis3;
    }

    public static AxisOrder fromString(String string) {
        if (string.length() != 3) {
            throw new Error();
        }
        Axis axis = Axis.fromChar(string.charAt(0));
        Axis axis2 = Axis.fromChar(string.charAt(1));
        Axis axis3 = Axis.fromChar(string.charAt(2));
        return new AxisOrder(axis, axis2, axis3);
    }

    public void fromENU(ProjCoordinate projCoordinate) {
        double d = this.x.fromENU(projCoordinate);
        double d2 = this.y.fromENU(projCoordinate);
        double d3 = this.z.fromENU(projCoordinate);
        projCoordinate.x = d;
        projCoordinate.y = d2;
        projCoordinate.z = d3;
    }

    public void toENU(ProjCoordinate projCoordinate) {
        double d = projCoordinate.x;
        double d2 = projCoordinate.y;
        double d3 = projCoordinate.z;
        this.x.toENU(d, projCoordinate);
        this.y.toENU(d2, projCoordinate);
        this.z.toENU(d3, projCoordinate);
    }

    public int hashCode() {
        return this.x.hashCode() | 17 * this.y.hashCode() | 37 * this.z.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AxisOrder) {
            AxisOrder axisOrder = (AxisOrder)object;
            return this.x == axisOrder.x && this.y == axisOrder.y && this.z == axisOrder.z;
        }
        return false;
    }

    public static enum Axis {
        Easting{

            @Override
            public double fromENU(ProjCoordinate projCoordinate) {
                return projCoordinate.x;
            }

            @Override
            public void toENU(double d, ProjCoordinate projCoordinate) {
                projCoordinate.x = d;
            }
        }
        ,
        Westing{

            @Override
            public double fromENU(ProjCoordinate projCoordinate) {
                return -projCoordinate.x;
            }

            @Override
            public void toENU(double d, ProjCoordinate projCoordinate) {
                projCoordinate.x = -d;
            }
        }
        ,
        Northing{

            @Override
            public double fromENU(ProjCoordinate projCoordinate) {
                return projCoordinate.y;
            }

            @Override
            public void toENU(double d, ProjCoordinate projCoordinate) {
                projCoordinate.y = d;
            }
        }
        ,
        Southing{

            @Override
            public double fromENU(ProjCoordinate projCoordinate) {
                return -projCoordinate.y;
            }

            @Override
            public void toENU(double d, ProjCoordinate projCoordinate) {
                projCoordinate.y = -d;
            }
        }
        ,
        Up{

            @Override
            public double fromENU(ProjCoordinate projCoordinate) {
                return projCoordinate.z;
            }

            @Override
            public void toENU(double d, ProjCoordinate projCoordinate) {
                projCoordinate.z = d;
            }
        }
        ,
        Down{

            @Override
            public double fromENU(ProjCoordinate projCoordinate) {
                return projCoordinate.z;
            }

            @Override
            public void toENU(double d, ProjCoordinate projCoordinate) {
                projCoordinate.z = -d;
            }
        };


        static Axis fromChar(char c) {
            switch (c) {
                case 'e': {
                    return Easting;
                }
                case 'n': {
                    return Northing;
                }
                case 'u': {
                    return Up;
                }
                case 'w': {
                    return Westing;
                }
                case 's': {
                    return Southing;
                }
                case 'd': {
                    return Down;
                }
            }
            throw new IllegalArgumentException();
        }

        public abstract double fromENU(ProjCoordinate var1);

        public abstract void toENU(double var1, ProjCoordinate var3);
    }
}

