/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j;

import java.text.DecimalFormat;

public class ProjCoordinate {
    public static String DECIMAL_FORMAT_PATTERN = "0.0###############";
    public static DecimalFormat DECIMAL_FORMAT = new DecimalFormat(DECIMAL_FORMAT_PATTERN);
    public double x;
    public double y;
    public double z;

    public ProjCoordinate() {
        this(0.0, 0.0);
    }

    public ProjCoordinate(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public ProjCoordinate(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.z = Double.NaN;
    }

    public ProjCoordinate(String string) {
        int n;
        int n2;
        boolean bl = string.startsWith("ProjCoordinate: ");
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The input string was not in the proper format.");
            throw illegalArgumentException;
        }
        String string2 = string.substring(16);
        String string3 = string2.substring(1);
        String string4 = string3.substring(0, n2 = (n = string3.length()) - 2);
        String[] stringArray = string4.split(" ");
        if (stringArray.length != 2 && stringArray.length != 3) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The input string was not in the proper format.");
            throw illegalArgumentException;
        }
        this.x = Double.parseDouble(stringArray[0]);
        this.y = Double.parseDouble(stringArray[0]);
        if (stringArray.length == 3) {
            this.z = Double.parseDouble(stringArray[0]);
        }
    }

    public void setValue(ProjCoordinate projCoordinate) {
        this.x = projCoordinate.x;
        this.y = projCoordinate.y;
        this.z = projCoordinate.z;
    }

    public void setValue(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.z = Double.NaN;
    }

    public void setValue(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void clearZ() {
        this.z = Double.NaN;
    }

    public boolean areXOrdinatesEqual(ProjCoordinate projCoordinate, double d) {
        double d2 = projCoordinate.x - this.x;
        return !(d2 > d);
    }

    public boolean areYOrdinatesEqual(ProjCoordinate projCoordinate, double d) {
        double d2 = projCoordinate.y - this.y;
        return !(d2 > d);
    }

    public boolean areZOrdinatesEqual(ProjCoordinate projCoordinate, double d) {
        if (Double.isNaN(this.z)) {
            return Double.isNaN(projCoordinate.z);
        }
        if (Double.isNaN(projCoordinate.z)) {
            return false;
        }
        double d2 = projCoordinate.z - this.z;
        return !(d2 > d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProjCoordinate)) {
            return false;
        }
        ProjCoordinate projCoordinate = (ProjCoordinate)object;
        if (this.x != projCoordinate.x) {
            return false;
        }
        return this.y == projCoordinate.y;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + ProjCoordinate.hashCode(this.x);
        n = 37 * n + ProjCoordinate.hashCode(this.y);
        return n;
    }

    private static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProjCoordinate[");
        stringBuilder.append(this.x);
        stringBuilder.append(" ");
        stringBuilder.append(this.y);
        stringBuilder.append(" ");
        stringBuilder.append(this.z);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(DECIMAL_FORMAT.format(this.x).replace(",", "."));
        stringBuilder.append(", ");
        stringBuilder.append(DECIMAL_FORMAT.format(this.y).replace(",", "."));
        if (!Double.isNaN(this.z)) {
            stringBuilder.append(", ");
            stringBuilder.append(this.z);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean hasValidZOrdinate() {
        return !Double.isNaN(this.z);
    }

    public boolean hasValidXandYOrdinates() {
        if (Double.isNaN(this.x)) {
            return false;
        }
        if (Double.isInfinite(this.x)) {
            return false;
        }
        if (Double.isNaN(this.y)) {
            return false;
        }
        return !Double.isInfinite(this.y);
    }
}

