/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.proj4;

import geotrellis.proj4.CRS;
import geotrellis.proj4.CRS$class;
import geotrellis.proj4.Memoize;
import geotrellis.proj4.io.wkt.WKT$;
import java.io.InputStream;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;

public final class CRS$
implements Serializable {
    public static final CRS$ MODULE$;
    private Memoize<String, Option<String>> proj4ToEPSGMap;
    private final CRSFactory geotrellis$proj4$CRS$$crsFactory;
    private final String filePrefix;
    private volatile boolean bitmap$0;

    static {
        new CRS$();
    }

    private Memoize proj4ToEPSGMap$lzycompute() {
        CRS$ cRS$ = this;
        synchronized (cRS$) {
            if (!this.bitmap$0) {
                this.proj4ToEPSGMap = new Memoize(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(String proj4String) {
                        return CRS$.MODULE$.geotrellis$proj4$CRS$$readEPSGCodeFromFile(proj4String);
                    }
                });
                this.bitmap$0 = true;
            }
            return this.proj4ToEPSGMap;
        }
    }

    private Memoize<String, Option<String>> proj4ToEPSGMap() {
        return this.bitmap$0 ? this.proj4ToEPSGMap : this.proj4ToEPSGMap$lzycompute();
    }

    public CRSFactory geotrellis$proj4$CRS$$crsFactory() {
        return this.geotrellis$proj4$CRS$$crsFactory;
    }

    private String filePrefix() {
        return this.filePrefix;
    }

    public CRS fromString(String proj4Params) {
        return new CRS(proj4Params){
            private final CoordinateReferenceSystem proj4jCrs;
            private final double Epsilon;

            public double Epsilon() {
                return this.Epsilon;
            }

            public void geotrellis$proj4$CRS$_setter_$Epsilon_$eq(double x$1) {
                this.Epsilon = x$1;
            }

            public Option<Function2<Object, Object, Tuple2<Object, Object>>> alternateTransform(CRS dest) {
                return CRS$class.alternateTransform(this, dest);
            }

            public Option<String> toWKT() {
                return CRS$class.toWKT(this);
            }

            public int hashCode() {
                return CRS$class.hashCode(this);
            }

            public String toProj4String() {
                return CRS$class.toProj4String(this);
            }

            public boolean isGeographic() {
                return CRS$class.isGeographic(this);
            }

            public boolean equals(Object o) {
                return CRS$class.equals(this, o);
            }

            public CRSFactory factory() {
                return CRS$class.factory(this);
            }

            public CoordinateReferenceSystem proj4jCrs() {
                return this.proj4jCrs;
            }

            public Option<Object> epsgCode() {
                return CRS$.MODULE$.getEPSGCode(new StringBuilder().append((Object)this.toProj4String()).append((Object)" <>").toString());
            }
            {
                CRS$class.$init$(this);
                this.proj4jCrs = CRS$.MODULE$.geotrellis$proj4$CRS$$crsFactory().createFromParameters(null, proj4Params$1);
            }
        };
    }

    public Option<Object> getEPSGCode(String proj4String) {
        return this.proj4ToEPSGMap().apply(proj4String).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        });
    }

    public CRS fromString(String name, String proj4Params) {
        return new CRS(name, proj4Params){
            private final CoordinateReferenceSystem proj4jCrs;
            private final double Epsilon;

            public double Epsilon() {
                return this.Epsilon;
            }

            public void geotrellis$proj4$CRS$_setter_$Epsilon_$eq(double x$1) {
                this.Epsilon = x$1;
            }

            public Option<Function2<Object, Object, Tuple2<Object, Object>>> alternateTransform(CRS dest) {
                return CRS$class.alternateTransform(this, dest);
            }

            public Option<String> toWKT() {
                return CRS$class.toWKT(this);
            }

            public int hashCode() {
                return CRS$class.hashCode(this);
            }

            public String toProj4String() {
                return CRS$class.toProj4String(this);
            }

            public boolean isGeographic() {
                return CRS$class.isGeographic(this);
            }

            public boolean equals(Object o) {
                return CRS$class.equals(this, o);
            }

            public CRSFactory factory() {
                return CRS$class.factory(this);
            }

            public CoordinateReferenceSystem proj4jCrs() {
                return this.proj4jCrs;
            }

            public Option<Object> epsgCode() {
                return CRS$.MODULE$.getEPSGCode(new StringBuilder().append((Object)this.toProj4String()).append((Object)" <>").toString());
            }
            {
                CRS$class.$init$(this);
                this.proj4jCrs = CRS$.MODULE$.geotrellis$proj4$CRS$$crsFactory().createFromParameters(name$1, proj4Params$2);
            }
        };
    }

    public CRS fromWKT(String wktString) {
        String epsgCode = WKT$.MODULE$.getEPSGCode(wktString);
        return this.fromName(epsgCode);
    }

    public CRS fromName(String name) {
        return new CRS(name){
            private final CoordinateReferenceSystem proj4jCrs;
            private final double Epsilon;

            public double Epsilon() {
                return this.Epsilon;
            }

            public void geotrellis$proj4$CRS$_setter_$Epsilon_$eq(double x$1) {
                this.Epsilon = x$1;
            }

            public Option<Function2<Object, Object, Tuple2<Object, Object>>> alternateTransform(CRS dest) {
                return CRS$class.alternateTransform(this, dest);
            }

            public Option<String> toWKT() {
                return CRS$class.toWKT(this);
            }

            public int hashCode() {
                return CRS$class.hashCode(this);
            }

            public String toProj4String() {
                return CRS$class.toProj4String(this);
            }

            public boolean isGeographic() {
                return CRS$class.isGeographic(this);
            }

            public boolean equals(Object o) {
                return CRS$class.equals(this, o);
            }

            public CRSFactory factory() {
                return CRS$class.factory(this);
            }

            public CoordinateReferenceSystem proj4jCrs() {
                return this.proj4jCrs;
            }

            public Option<Object> epsgCode() {
                return CRS$.MODULE$.getEPSGCode(new StringBuilder().append((Object)this.toProj4String()).append((Object)" <>").toString());
            }
            {
                CRS$class.$init$(this);
                this.proj4jCrs = CRS$.MODULE$.geotrellis$proj4$CRS$$crsFactory().createFromName(name$2);
            }
        };
    }

    public CRS fromEpsgCode(int epsgCode) {
        return this.fromName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EPSG:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epsgCode)})));
    }

    /*
     * WARNING - void declaration
     */
    public Option<String> geotrellis$proj4$CRS$$readEPSGCodeFromFile(String proj4String) {
        Option option;
        InputStream stream = this.getClass().getResourceAsStream(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "epsg"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filePrefix()})));
        try {
            option = Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).getLines().find((Function1)new Serializable(proj4String){
                public static final long serialVersionUID = 0L;
                private final String proj4String$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(String line) {
                    if (line.startsWith("#")) return false;
                    String proj4Body = line.split("proj")[1];
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+proj", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proj4Body}));
                    String string2 = this.proj4String$1;
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
                {
                    this.proj4String$1 = proj4String$1;
                }
            }).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Some<String> apply(String l) {
                    String[] array = l.split(" ");
                    int length = array[0].length();
                    return new Some((Object)array[0].substring(1, length - 1));
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        stream.close();
        return option;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CRS$() {
        MODULE$ = this;
        this.geotrellis$proj4$CRS$$crsFactory = new CRSFactory();
        this.filePrefix = "/geotrellis/proj4/nad/";
    }
}

