/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CollectionUtils {
    private static Comparator<?> LT_NULL_SMALLEST = new NegativeComparatorWithNullAsSmallest();
    private static Comparator<?> GT_NULL_GREATEST = new PositiveComparatorWithNullAsGreatest();

    public static <T, V> List<V> apply(Collection<T> collection, Function<T, V> function) {
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(function.eval(t));
        }
        return list;
    }

    public static <T, V> V bestValue(Collection<T> collection, Function<T, V> function, Comparator<V> comparator) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Iterator<T> i = collection.iterator();
        V candidateValue = function.eval(i.next());
        while (i.hasNext()) {
            V nextValue = function.eval(i.next());
            if (comparator.compare(candidateValue, nextValue) >= 0) continue;
            candidateValue = nextValue;
        }
        return candidateValue;
    }

    public static <V> Comparator<V> ltWithNullAsSmallest() {
        Comparator<?> comparator = LT_NULL_SMALLEST;
        return comparator;
    }

    public static <V> Comparator<V> gtWithNullAsGreatest() {
        Comparator<?> comparator = GT_NULL_GREATEST;
        return comparator;
    }

    public static interface Function<T, V> {
        public V eval(T var1);
    }

    public static class NegativeComparatorWithNullAsSmallest<V>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return -((Comparable)o1).compareTo(o2);
        }
    }

    public static class PositiveComparatorWithNullAsGreatest<V>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

