/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2;

import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.jaxb2.maven2.AbstractXJC2Mojo;
import org.jvnet.jaxb2.maven2.OptionsConfiguration;
import org.jvnet.jaxb2.maven2.ParentFirstClassLoader;
import org.jvnet.jaxb2.maven2.ResourceEntry;
import org.jvnet.jaxb2.maven2.net.CompositeURILastModifiedResolver;
import org.jvnet.jaxb2.maven2.net.URILastModifiedResolver;
import org.jvnet.jaxb2.maven2.resolver.tools.MavenCatalogResolver;
import org.jvnet.jaxb2.maven2.resolver.tools.ReResolvingEntityResolverWrapper;
import org.jvnet.jaxb2.maven2.util.ArtifactUtils;
import org.jvnet.jaxb2.maven2.util.CollectionUtils;
import org.jvnet.jaxb2.maven2.util.IOUtils;
import org.jvnet.jaxb2.maven2.util.LocaleUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class RawXJC2Mojo<O>
extends AbstractXJC2Mojo<O> {
    private Collection<Artifact> xjcPluginArtifacts;
    private Collection<File> xjcPluginFiles;
    private List<URL> xjcPluginURLs;
    private Collection<Artifact> episodeArtifacts;
    private Collection<File> episodeFiles;
    private List<File> schemaFiles;
    private List<URI> schemaURIs;
    private List<URI> resolvedSchemaURIs;
    private List<InputSource> grammars;
    private List<File> bindingFiles;
    private List<URI> bindingURIs;
    private List<URI> resolvedBindingURIs;
    private List<InputSource> bindFiles;
    private List<URI> dependsURIs;
    private List<URI> producesURIs;
    private static final Object lock = new Object();
    private URILastModifiedResolver uriLastModifiedResolver;
    private CatalogResolver catalogResolverInstance;
    private List<URI> catalogURIs;
    private List<URI> resolvedCatalogURIs;
    private EntityResolver entityResolver;

    public Collection<Artifact> getXjcPluginArtifacts() {
        return this.xjcPluginArtifacts;
    }

    public Collection<File> getXjcPluginFiles() {
        return this.xjcPluginFiles;
    }

    public List<URL> getXjcPluginURLs() {
        return this.xjcPluginURLs;
    }

    public Collection<Artifact> getEpisodeArtifacts() {
        return this.episodeArtifacts;
    }

    public Collection<File> getEpisodeFiles() {
        return this.episodeFiles;
    }

    public List<File> getSchemaFiles() {
        return this.schemaFiles;
    }

    protected List<URI> getSchemaURIs() {
        if (this.schemaURIs == null) {
            throw new IllegalStateException("Schema URIs were not set up yet.");
        }
        return this.schemaURIs;
    }

    protected List<URI> getResolvedSchemaURIs() {
        if (this.resolvedSchemaURIs == null) {
            throw new IllegalStateException("Resolved schema URIs were not set up yet.");
        }
        return this.resolvedSchemaURIs;
    }

    protected List<InputSource> getGrammars() {
        if (this.grammars == null) {
            throw new IllegalArgumentException("Grammars were not set up yet.");
        }
        return this.grammars;
    }

    private void setupSchemas() throws MojoExecutionException {
        this.schemaURIs = this.createSchemaURIs();
        this.resolvedSchemaURIs = this.resolveURIs(this.getSchemaURIs());
        this.grammars = this.createGrammars();
    }

    private List<URI> createSchemaURIs() throws MojoExecutionException {
        List<File> schemaFiles = this.getSchemaFiles();
        ArrayList<URI> schemaURIs = new ArrayList<URI>(schemaFiles.size());
        for (File schemaFile : schemaFiles) {
            URI schema = schemaFile.toURI();
            schemaURIs.add(schema);
        }
        ResourceEntry[] schemas = this.getSchemas();
        if (schemas != null) {
            for (ResourceEntry resourceEntry : schemas) {
                schemaURIs.addAll(this.createResourceEntryUris(resourceEntry, this.getSchemaDirectory().getAbsolutePath(), this.getSchemaIncludes(), this.getSchemaExcludes()));
            }
        }
        return schemaURIs;
    }

    private List<InputSource> createGrammars() throws MojoExecutionException {
        try {
            List<URI> schemaURIs = this.getSchemaURIs();
            return this.getInputSources(schemaURIs);
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not resolve grammars.", (Exception)ioex);
        }
        catch (SAXException ioex) {
            throw new MojoExecutionException("Could not resolve grammars.", (Exception)ioex);
        }
    }

    public List<File> getBindingFiles() {
        return this.bindingFiles;
    }

    protected List<URI> getBindingURIs() {
        if (this.bindingURIs == null) {
            throw new IllegalStateException("Binding URIs were not set up yet.");
        }
        return this.bindingURIs;
    }

    protected List<URI> getResolvedBindingURIs() {
        if (this.resolvedBindingURIs == null) {
            throw new IllegalStateException("Resolved binding URIs were not set up yet.");
        }
        return this.resolvedBindingURIs;
    }

    protected List<InputSource> getBindFiles() {
        if (this.bindFiles == null) {
            throw new IllegalStateException("BindFiles were not set up yet.");
        }
        return this.bindFiles;
    }

    private void setupBindings() throws MojoExecutionException {
        this.bindingURIs = this.createBindingURIs();
        this.resolvedBindingURIs = this.resolveURIs(this.getBindingURIs());
        this.bindFiles = this.createBindFiles();
    }

    protected List<URI> createBindingURIs() throws MojoExecutionException {
        LinkedList<File> bindingFiles = new LinkedList<File>();
        bindingFiles.addAll(this.getBindingFiles());
        for (File episodeFile : this.getEpisodeFiles()) {
            File episodeBindingsFile;
            File episodeMetaInfFile;
            this.getLog().debug((CharSequence)MessageFormat.format("Checking episode file [{0}].", episodeFile.getAbsolutePath()));
            if (!episodeFile.isDirectory() || !(episodeMetaInfFile = new File(episodeFile, "META-INF")).isDirectory() || !(episodeBindingsFile = new File(episodeMetaInfFile, "sun-jaxb.episode")).isFile()) continue;
            bindingFiles.add(episodeBindingsFile);
        }
        ArrayList<URI> bindingUris = new ArrayList<URI>(bindingFiles.size());
        for (File bindingFile : bindingFiles) {
            URI uri = bindingFile.toURI();
            bindingUris.add(uri);
        }
        if (this.getBindings() != null) {
            for (ResourceEntry resourceEntry : this.getBindings()) {
                bindingUris.addAll(this.createResourceEntryUris(resourceEntry, this.getBindingDirectory().getAbsolutePath(), this.getBindingIncludes(), this.getBindingExcludes()));
            }
        }
        if (this.getScanDependenciesForBindings()) {
            this.collectBindingUrisFromDependencies(bindingUris);
        }
        return bindingUris;
    }

    private List<InputSource> createBindFiles() throws MojoExecutionException {
        try {
            List<URI> bindingURIs = this.getBindingURIs();
            return this.getInputSources(bindingURIs);
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not resolve binding files.", (Exception)ioex);
        }
        catch (SAXException ioex) {
            throw new MojoExecutionException("Could not resolve binding files.", (Exception)ioex);
        }
    }

    public List<URI> getDependsURIs() {
        return this.dependsURIs;
    }

    public List<URI> getProducesURIs() {
        return this.producesURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Object object = lock;
        synchronized (object) {
            this.injectDependencyDefaults();
            this.resolveArtifacts();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = this.createClassLoader(currentClassLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
            Locale currentDefaultLocale = Locale.getDefault();
            try {
                Locale locale = LocaleUtils.valueOf(this.getLocale());
                Locale.setDefault(locale);
                this.doExecute();
            }
            finally {
                Locale.setDefault(currentDefaultLocale);
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    protected void injectDependencyDefaults() {
        this.injectDependencyDefaults(this.getPlugins());
        this.injectDependencyDefaults(this.getEpisodes());
    }

    protected void injectDependencyDefaults(Dependency[] dependencies) {
        if (dependencies != null) {
            TreeMap<String, Dependency> dependencyMap = new TreeMap<String, Dependency>();
            for (Dependency dependency : dependencies) {
                if (dependency.getScope() == null) {
                    dependency.setScope("runtime");
                }
                dependencyMap.put(dependency.getManagementKey(), dependency);
            }
            DependencyManagement dependencyManagement = this.getProject().getDependencyManagement();
            if (dependencyManagement != null) {
                this.merge(dependencyMap, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null) {
                this.merge(dependencyMap, this.getProject().getDependencies());
            }
        }
    }

    private void merge(Map<String, Dependency> dependencyMap, List<Dependency> managedDependencies) {
        for (Dependency managedDependency : managedDependencies) {
            String key = managedDependency.getManagementKey();
            Dependency dependency = dependencyMap.get(key);
            if (dependency == null) continue;
            ArtifactUtils.mergeDependencyWithDefaults(dependency, managedDependency);
        }
    }

    protected void resolveArtifacts() throws MojoExecutionException {
        try {
            this.resolveXJCPluginArtifacts();
            this.resolveEpisodeArtifacts();
        }
        catch (ArtifactResolutionException arex) {
            throw new MojoExecutionException("Could not resolve the artifact.", (Exception)((Object)arex));
        }
        catch (ArtifactNotFoundException anfex) {
            throw new MojoExecutionException("Artifact not found.", (Exception)((Object)anfex));
        }
        catch (InvalidDependencyVersionException idvex) {
            throw new MojoExecutionException("Invalid dependency version.", (Exception)((Object)idvex));
        }
    }

    protected void resolveXJCPluginArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        this.xjcPluginArtifacts = ArtifactUtils.resolveTransitively(this.getArtifactFactory(), this.getArtifactResolver(), this.getLocalRepository(), this.getArtifactMetadataSource(), this.getPlugins(), this.getProject());
        this.xjcPluginFiles = ArtifactUtils.getFiles(this.xjcPluginArtifacts);
        this.xjcPluginURLs = CollectionUtils.apply(this.xjcPluginFiles, IOUtils.GET_URL);
    }

    protected void resolveEpisodeArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        this.episodeArtifacts = new LinkedHashSet<Artifact>();
        Collection<Artifact> episodeArtifacts = ArtifactUtils.resolve(this.getArtifactFactory(), this.getArtifactResolver(), this.getLocalRepository(), this.getArtifactMetadataSource(), this.getEpisodes(), this.getProject());
        this.episodeArtifacts.addAll(episodeArtifacts);
        if (this.getUseDependenciesAsEpisodes()) {
            Set projectArtifacts = this.getProject().getArtifacts();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("compile");
            for (Artifact artifact : projectArtifacts) {
                if (!filter.include(artifact)) continue;
                this.episodeArtifacts.add(artifact);
            }
        }
        this.episodeFiles = ArtifactUtils.getFiles(this.episodeArtifacts);
    }

    protected ClassLoader createClassLoader(ClassLoader parent) {
        List<URL> xjcPluginURLs = this.getXjcPluginURLs();
        return new ParentFirstClassLoader(xjcPluginURLs.toArray(new URL[xjcPluginURLs.size()]), parent);
    }

    protected void doExecute() throws MojoExecutionException {
        this.setupLogging();
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Started execution.");
        }
        this.setupMavenPaths();
        this.setupCatalogResolver();
        this.setupEntityResolver();
        this.setupSchemaFiles();
        this.setupBindingFiles();
        this.setupSchemas();
        this.setupBindings();
        this.setupDependsURIs();
        this.setupProducesURIs();
        this.setupURILastModifiedResolver();
        if (this.getVerbose()) {
            this.logConfiguration();
        }
        OptionsConfiguration optionsConfiguration = this.createOptionsConfiguration();
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)("optionsConfiguration:" + optionsConfiguration));
        }
        this.checkCatalogsInStrictMode();
        if (this.getGrammars().isEmpty()) {
            this.getLog().warn((CharSequence)"No schemas to compile. Skipping XJC execution. ");
        } else {
            Object options = this.getOptionsFactory().createOptions(optionsConfiguration);
            if (this.getForceRegenerate()) {
                this.getLog().warn((CharSequence)"You are using forceRegenerate=true in your configuration.\nThis configuration setting is deprecated and not recommended as it causes problems with incremental builds in IDEs.\nPlease refer to the following link for more information:\nhttps://github.com/highsource/maven-jaxb2-plugin/wiki/Do-Not-Use-forceRegenerate\nConsider removing this setting from your plugin configuration.\n");
                this.getLog().info((CharSequence)"The [forceRegenerate] switch is turned on, XJC will be executed.");
            } else {
                boolean isUpToDate = this.isUpToDate();
                if (!isUpToDate) {
                    this.getLog().info((CharSequence)"Sources are not up-to-date, XJC will be executed.");
                } else {
                    this.getLog().info((CharSequence)"Sources are up-to-date, XJC will be skipped.");
                    return;
                }
            }
            this.setupDirectories();
            this.doExecute(options);
            BuildContext buildContext = this.getBuildContext();
            this.getLog().debug((CharSequence)MessageFormat.format("Refreshing the generated directory [{0}].", this.getGenerateDirectory().getAbsolutePath()));
            buildContext.refresh(this.getGenerateDirectory());
        }
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Finished execution.");
        }
    }

    private void setupURILastModifiedResolver() {
        this.uriLastModifiedResolver = new CompositeURILastModifiedResolver(this.getLog());
    }

    protected URILastModifiedResolver getURILastModifiedResolver() {
        if (this.uriLastModifiedResolver == null) {
            throw new IllegalStateException("URILastModifiedResolver was not set up yet.");
        }
        return this.uriLastModifiedResolver;
    }

    private void checkCatalogsInStrictMode() {
        if (this.getStrict() && !this.getCatalogURIs().isEmpty()) {
            this.getLog().warn((CharSequence)"The plugin is configured to use catalogs and strict mode at the same time.\nUsing catalogs to resolve schema URI in strict mode is known to be problematic and may fail.\nPlease refer to the following link for more information:\nhttps://github.com/highsource/maven-jaxb2-plugin/wiki/Catalogs-in-Strict-Mode\nConsider setting <strict>false</strict> in your plugin configuration.\n");
        }
    }

    public abstract void doExecute(O var1) throws MojoExecutionException;

    protected void setupLogging() {
        this.setVerbose(this.getVerbose() || this.getLog().isDebugEnabled());
        if (this.getVerbose()) {
            System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        }
    }

    protected void setupMavenPaths() {
        String generatedDirectoryPath;
        String episodeFilePath;
        if (this.getAddCompileSourceRoot()) {
            this.getProject().addCompileSourceRoot(this.getGenerateDirectory().getPath());
        }
        if (this.getAddTestCompileSourceRoot()) {
            this.getProject().addTestCompileSourceRoot(this.getGenerateDirectory().getPath());
        }
        if (this.getEpisode() && this.getEpisodeFile() != null && (episodeFilePath = this.getEpisodeFile().getAbsolutePath()).startsWith((generatedDirectoryPath = this.getGenerateDirectory().getAbsolutePath()) + File.separator)) {
            String path = episodeFilePath.substring(generatedDirectoryPath.length() + 1);
            Resource resource = new Resource();
            resource.setDirectory(generatedDirectoryPath);
            resource.addInclude(path);
            if (this.getAddCompileSourceRoot()) {
                this.getProject().addResource(resource);
            }
            if (this.getAddTestCompileSourceRoot()) {
                this.getProject().addTestResource(resource);
            }
        }
    }

    protected void setupDirectories() {
        File generateDirectory = this.getGenerateDirectory();
        if (this.getRemoveOldOutput() && generateDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.getGenerateDirectory());
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)("Failed to remove old generateDirectory [" + generateDirectory + "]."), (Throwable)ex);
            }
        }
        if (generateDirectory != null && !generateDirectory.exists()) {
            generateDirectory.mkdirs();
        }
        File episodeFile = this.getEpisodeFile();
        if (this.getEpisode() && episodeFile != null) {
            File parentFile = episodeFile.getParentFile();
            parentFile.mkdirs();
        }
    }

    protected void setupSchemaFiles() throws MojoExecutionException {
        try {
            File schemaDirectory = this.getSchemaDirectory();
            if (schemaDirectory == null || !schemaDirectory.exists()) {
                this.schemaFiles = Collections.emptyList();
            } else if (schemaDirectory.isDirectory()) {
                this.schemaFiles = IOUtils.scanDirectoryForFiles(this.getBuildContext(), schemaDirectory, this.getSchemaIncludes(), this.getSchemaExcludes(), !this.getDisableDefaultExcludes());
            } else {
                this.schemaFiles = Collections.emptyList();
                this.getLog().warn((CharSequence)MessageFormat.format("Schema directory [{0}] is not a directory.", schemaDirectory.getPath()));
            }
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not setup schema files.", (Exception)ioex);
        }
    }

    protected void setupBindingFiles() throws MojoExecutionException {
        try {
            File bindingDirectory = this.getBindingDirectory();
            if (bindingDirectory == null || !bindingDirectory.exists()) {
                this.bindingFiles = Collections.emptyList();
            } else if (bindingDirectory.isDirectory()) {
                this.bindingFiles = IOUtils.scanDirectoryForFiles(this.getBuildContext(), bindingDirectory, this.getBindingIncludes(), this.getBindingExcludes(), !this.getDisableDefaultExcludes());
            } else {
                this.bindingFiles = Collections.emptyList();
                this.getLog().warn((CharSequence)MessageFormat.format("Binding directory [{0}] is not a directory.", bindingDirectory.getPath()));
            }
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not setup binding files.", (Exception)ioex);
        }
    }

    protected void setupDependsURIs() {
        LinkedList<URI> dependsURIs = new LinkedList<URI>();
        dependsURIs.addAll(this.getResolvedCatalogURIs());
        dependsURIs.addAll(this.getResolvedSchemaURIs());
        dependsURIs.addAll(this.getResolvedBindingURIs());
        File projectFile = this.getProject().getFile();
        if (projectFile != null) {
            dependsURIs.add(projectFile.toURI());
        }
        if (this.getOtherDepends() != null) {
            for (File file : this.getOtherDepends()) {
                if (file == null) continue;
                dependsURIs.add(file.toURI());
            }
        }
        this.dependsURIs = dependsURIs;
    }

    private void setupProducesURIs() throws MojoExecutionException {
        this.producesURIs = this.createProducesURIs();
    }

    protected List<URI> createProducesURIs() throws MojoExecutionException {
        LinkedList<URI> producesURIs = new LinkedList<URI>();
        try {
            List<File> producesFiles = IOUtils.scanDirectoryForFiles(this.getBuildContext(), this.getGenerateDirectory(), this.getProduces(), new String[]{}, !this.getDisableDefaultExcludes());
            if (producesFiles != null) {
                for (File producesFile : producesFiles) {
                    if (producesFile == null) continue;
                    producesURIs.add(producesFile.toURI());
                }
            }
            return producesURIs;
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not setup produced files.", (Exception)ioex);
        }
    }

    @Override
    protected void logConfiguration() throws MojoExecutionException {
        super.logConfiguration();
        this.getLog().info((CharSequence)("catalogURIs (calculated):" + this.getCatalogURIs()));
        this.getLog().info((CharSequence)("resolvedCatalogURIs (calculated):" + this.getResolvedCatalogURIs()));
        this.getLog().info((CharSequence)("schemaFiles (calculated):" + this.getSchemaFiles()));
        this.getLog().info((CharSequence)("schemaURIs (calculated):" + this.getSchemaURIs()));
        this.getLog().info((CharSequence)("resolvedSchemaURIs (calculated):" + this.getResolvedSchemaURIs()));
        this.getLog().info((CharSequence)("bindingFiles (calculated):" + this.getBindingFiles()));
        this.getLog().info((CharSequence)("bindingURIs (calculated):" + this.getBindingURIs()));
        this.getLog().info((CharSequence)("resolvedBindingURIs (calculated):" + this.getResolvedBindingURIs()));
        this.getLog().info((CharSequence)("xjcPluginArtifacts (resolved):" + this.getXjcPluginArtifacts()));
        this.getLog().info((CharSequence)("xjcPluginFiles (resolved):" + this.getXjcPluginFiles()));
        this.getLog().info((CharSequence)("xjcPluginURLs (resolved):" + this.getXjcPluginURLs()));
        this.getLog().info((CharSequence)("episodeArtifacts (resolved):" + this.getEpisodeArtifacts()));
        this.getLog().info((CharSequence)("episodeFiles (resolved):" + this.getEpisodeFiles()));
    }

    private void collectBindingUrisFromDependencies(List<URI> bindingUris) throws MojoExecutionException {
        Set projectArtifacts = this.getProject().getArtifacts();
        ArrayList<Artifact> compileScopeArtifacts = new ArrayList<Artifact>(projectArtifacts.size());
        ScopeArtifactFilter filter = new ScopeArtifactFilter("compile");
        for (Artifact artifact : projectArtifacts) {
            if (!filter.include(artifact)) continue;
            compileScopeArtifacts.add(artifact);
        }
        for (Artifact artifact : compileScopeArtifacts) {
            this.getLog().debug((CharSequence)MessageFormat.format("Scanning artifact [{0}] for JAXB binding files.", artifact));
            File file = artifact.getFile();
            URLClassLoader classLoader = null;
            try {
                classLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Unable to create a classloader for the artifact file [" + file.getAbsolutePath() + "].", (Exception)ioex);
            }
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> jarFileEntries = jarFile.entries();
                while (jarFileEntries.hasMoreElements()) {
                    JarEntry entry = jarFileEntries.nextElement();
                    if (!entry.getName().endsWith(".xjb")) continue;
                    URL resource = classLoader.getResource(entry.getName());
                    try {
                        bindingUris.add(resource.toURI());
                    }
                    catch (URISyntaxException urisex) {
                        throw new MojoExecutionException(MessageFormat.format("Could not create the URI of the binding file from [{0}]", resource), (Exception)urisex);
                    }
                }
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Unable to read the artifact JAR file [" + file.getAbsolutePath() + "].", (Exception)ioex);
            }
            finally {
                if (jarFile == null) continue;
                try {
                    jarFile.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected List<URI> getCatalogURIs() {
        if (this.catalogURIs == null) {
            throw new IllegalStateException("Catalog URIs were not set up yet.");
        }
        return this.catalogURIs;
    }

    protected List<URI> getResolvedCatalogURIs() {
        if (this.resolvedCatalogURIs == null) {
            throw new IllegalStateException("Resolved catalog URIs were not set up yet.");
        }
        return this.resolvedCatalogURIs;
    }

    protected CatalogResolver getCatalogResolverInstance() {
        if (this.catalogResolverInstance == null) {
            throw new IllegalStateException("Catalog resolver was not set up yet.");
        }
        return this.catalogResolverInstance;
    }

    private void setupCatalogResolver() throws MojoExecutionException {
        this.catalogResolverInstance = this.createCatalogResolver();
        this.catalogURIs = this.createCatalogURIs();
        this.resolvedCatalogURIs = this.resolveURIs(this.getCatalogURIs());
        this.parseResolvedCatalogURIs();
    }

    protected EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            throw new IllegalStateException("Entity resolver was not set up yet.");
        }
        return this.entityResolver;
    }

    private void setupEntityResolver() {
        this.entityResolver = this.createEntityResolver(this.getCatalogResolverInstance());
    }

    protected EntityResolver createEntityResolver(CatalogResolver catalogResolver) {
        ReResolvingEntityResolverWrapper entityResolver = new ReResolvingEntityResolverWrapper((EntityResolver)catalogResolver);
        return entityResolver;
    }

    protected CatalogResolver createCatalogResolver() throws MojoExecutionException {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        if (this.getLog().isDebugEnabled()) {
            catalogManager.setVerbosity(Integer.MAX_VALUE);
        }
        if (this.getCatalogResolver() == null) {
            return new MavenCatalogResolver(catalogManager, this, this.getLog());
        }
        String catalogResolverClassName = this.getCatalogResolver().trim();
        return this.createCatalogResolverByClassName(catalogResolverClassName);
    }

    private CatalogResolver createCatalogResolverByClassName(String catalogResolverClassName) throws MojoExecutionException {
        try {
            Class<?> draftCatalogResolverClass = Thread.currentThread().getContextClassLoader().loadClass(catalogResolverClassName);
            if (!CatalogResolver.class.isAssignableFrom(draftCatalogResolverClass)) {
                throw new MojoExecutionException(MessageFormat.format("Specified catalog resolver class [{0}] could not be casted to [{1}].", this.catalogResolver, CatalogResolver.class));
            }
            Class<?> catalogResolverClass = draftCatalogResolverClass;
            CatalogResolver catalogResolverInstance = (CatalogResolver)catalogResolverClass.newInstance();
            return catalogResolverInstance;
        }
        catch (ClassNotFoundException cnfex) {
            throw new MojoExecutionException(MessageFormat.format("Could not find specified catalog resolver class [{0}].", this.catalogResolver), (Exception)cnfex);
        }
        catch (InstantiationException iex) {
            throw new MojoExecutionException(MessageFormat.format("Could not instantiate catalog resolver class [{0}].", this.catalogResolver), (Exception)iex);
        }
        catch (IllegalAccessException iaex) {
            throw new MojoExecutionException(MessageFormat.format("Could not instantiate catalog resolver class [{0}].", this.catalogResolver), (Exception)iaex);
        }
    }

    protected boolean isUpToDate() throws MojoExecutionException {
        List<URI> dependsURIs = this.getDependsURIs();
        List<URI> producesURIs = this.getProducesURIs();
        this.getLog().info((CharSequence)MessageFormat.format("Up-to-date check for source resources [{0}] and taret resources [{1}].", dependsURIs, producesURIs));
        boolean itIsKnownThatNoDependsURIsWereChanged = true;
        for (URI dependsURI : dependsURIs) {
            if ("file".equalsIgnoreCase(dependsURI.getScheme())) {
                File dependsFile = new File(dependsURI);
                if (!this.getBuildContext().hasDelta(dependsFile)) continue;
                if (this.getVerbose()) {
                    this.getLog().debug((CharSequence)MessageFormat.format("File [{0}] might have been changed since the last build.", dependsFile.getAbsolutePath()));
                }
                itIsKnownThatNoDependsURIsWereChanged = false;
                continue;
            }
            itIsKnownThatNoDependsURIsWereChanged = false;
        }
        if (itIsKnownThatNoDependsURIsWereChanged) {
            this.getLog().info((CharSequence)"According to the build context, all of the [dependURIs] are up-to-date.");
            return true;
        }
        CollectionUtils.Function<URI, Long> LAST_MODIFIED = new CollectionUtils.Function<URI, Long>(){

            @Override
            public Long eval(URI uri) {
                return RawXJC2Mojo.this.getURILastModifiedResolver().getLastModified(uri);
            }
        };
        this.getLog().debug((CharSequence)MessageFormat.format("Checking the last modification timestamp of the source resources [{0}].", dependsURIs));
        Long dependsTimestamp = CollectionUtils.bestValue(dependsURIs, LAST_MODIFIED, CollectionUtils.gtWithNullAsGreatest());
        this.getLog().debug((CharSequence)MessageFormat.format("Checking the last modification timestamp of the target resources [{0}].", producesURIs));
        Long producesTimestamp = CollectionUtils.bestValue(producesURIs, LAST_MODIFIED, CollectionUtils.ltWithNullAsSmallest());
        if (dependsTimestamp == null) {
            this.getLog().debug((CharSequence)"Latest timestamp of the source resources is unknown. Assuming that something was changed.");
            return false;
        }
        if (producesTimestamp == null) {
            this.getLog().debug((CharSequence)MessageFormat.format("Latest Timestamp of the source resources is [{0,date,yyyy-MM-dd HH:mm:ss.SSS}], however the ealiest timestamp of the target resources is not unknown. Assuming that something was changed.", dependsTimestamp));
            return false;
        }
        this.getLog().info((CharSequence)MessageFormat.format("Latest timestamp of the source resources is [{0,date,yyyy-MM-dd HH:mm:ss.SSS}], ealiest timestamp of the target resources is [{1,date,yyyy-MM-dd HH:mm:ss.SSS}].", dependsTimestamp, producesTimestamp));
        boolean upToDate = dependsTimestamp < producesTimestamp;
        return upToDate;
    }

    protected List<String> getArguments() {
        ArrayList<String> arguments = new ArrayList<String>(this.getArgs());
        if (this.getEpisode() && this.getEpisodeFile() != null) {
            arguments.add("-episode");
            arguments.add(this.getEpisodeFile().getAbsolutePath());
        }
        if (this.getMarkGenerated()) {
            arguments.add("-mark-generated");
        }
        for (File episodeFile : this.getEpisodeFiles()) {
            if (!episodeFile.isFile()) continue;
            arguments.add(episodeFile.getAbsolutePath());
        }
        return arguments;
    }

    public OptionsConfiguration createOptionsConfiguration() throws MojoExecutionException {
        OptionsConfiguration optionsConfiguration = new OptionsConfiguration(this.getEncoding(), this.getSchemaLanguage(), this.getGrammars(), this.getBindFiles(), this.getEntityResolver(), this.getGeneratePackage(), this.getGenerateDirectory(), this.getReadOnly(), this.getPackageLevelAnnotations(), this.getNoFileHeader(), this.getEnableIntrospection(), this.getDisableXmlSecurity(), this.getAccessExternalSchema(), this.getAccessExternalDTD(), this.getContentForWildcard(), this.getExtension(), this.getStrict(), this.getVerbose(), this.getDebug(), this.getArguments(), this.getXjcPluginURLs(), this.getSpecVersion());
        return optionsConfiguration;
    }

    private List<URI> resolveURIs(List<URI> uris) {
        ArrayList<URI> resolvedURIs = new ArrayList<URI>(uris.size());
        for (URI uri : uris) {
            String URI2 = this.getCatalogResolverInstance().getResolvedEntity(null, uri.toString());
            if (URI2 != null) {
                try {
                    uri = new URI(URI2);
                }
                catch (URISyntaxException ignored) {
                    // empty catch block
                }
            }
            resolvedURIs.add(uri);
        }
        return resolvedURIs;
    }

    private void parseResolvedCatalogURIs() throws MojoExecutionException {
        for (URI catalogURI : this.getResolvedCatalogURIs()) {
            if (catalogURI == null) continue;
            try {
                this.getCatalogResolverInstance().getCatalog().parseCatalog(catalogURI.toURL());
            }
            catch (IOException ioex) {
                throw new MojoExecutionException(MessageFormat.format("Error parsing catalog [{0}].", catalogURI.toString()), (Exception)ioex);
            }
        }
    }

    private List<InputSource> getInputSources(List<URI> uris) throws IOException, SAXException {
        ArrayList<InputSource> inputSources = new ArrayList<InputSource>(uris.size());
        for (URI uri : uris) {
            InputSource inputSource = IOUtils.getInputSource(uri);
            InputSource resolvedInputSource = this.getEntityResolver().resolveEntity(inputSource.getPublicId(), inputSource.getSystemId());
            if (resolvedInputSource != null) {
                inputSource = resolvedInputSource;
            }
            inputSources.add(inputSource);
        }
        return inputSources;
    }
}

