/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.maven.plugin.logging.slfj4;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;
import org.hisrc.maven.plugin.logging.slfj4.LogLogger;
import org.hisrc.maven.plugin.logging.slfj4.LogLoggerConfiguration;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LogLoggerFactory
implements ILoggerFactory {
    private final ConcurrentMap<String, Logger> loggerMap;
    private final Log log;
    private final LogLoggerConfiguration configuration;

    public LogLoggerFactory(Log log, Properties properties) {
        this.log = (Log)Validate.notNull((Object)log);
        this.loggerMap = new ConcurrentHashMap<String, Logger>();
        this.configuration = new LogLoggerConfiguration((Properties)Validate.notNull((Object)properties));
    }

    public LogLoggerFactory(Log log) {
        this(log, new Properties());
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)this.loggerMap.get(name);
        if (logger != null) {
            return logger;
        }
        int logLevel = this.configuration.getLogLevel(name);
        LogLogger newInstance = new LogLogger(this.log, this.configuration, logLevel, name);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, (Logger)newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    void reset() {
        this.loggerMap.clear();
    }
}

