/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.maven.plugin.logging.slfj4;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.slf4j.helpers.Util;

public class LogLoggerConfiguration {
    private final long startTime = System.currentTimeMillis();
    private final Properties properties;
    private int defaultLogLevel = 20;
    private boolean showDateTime = false;
    private String dateTimeFormatString = null;
    private DateFormat dateFormatter = null;
    private boolean showThreadName = true;
    private boolean showLogName = true;
    private boolean showShortLogName = false;
    public static final String SYSTEM_PREFIX = "org.hisrc.maven.plugin.logging.slfj4.logLogger.";
    public static final String DEFAULT_LOG_LEVEL_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.defaultLogLevel";
    public static final String SHOW_DATE_TIME_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.showDateTime";
    public static final String DATE_TIME_FORMAT_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.dateTimeFormat";
    public static final String SHOW_THREAD_NAME_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.showThreadName";
    public static final String SHOW_LOG_NAME_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.showLogName";
    public static final String SHOW_SHORT_LOG_NAME_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.showShortLogName";
    public static final String LOG_FILE_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.logFile";
    public static final String LEVEL_IN_BRACKETS_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.levelInBrackets";
    public static final String WARN_LEVEL_STRING_KEY = "org.hisrc.maven.plugin.logging.slfj4.logLogger.warnLevelString";
    public static final String LOG_KEY_PREFIX = "org.hisrc.maven.plugin.logging.slfj4.logLogger.log.";

    private String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? this.properties.getProperty(name) : prop;
    }

    private String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    private boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    void init() {
        String defaultLogLevelString = this.getStringProperty(DEFAULT_LOG_LEVEL_KEY, null);
        if (defaultLogLevelString != null) {
            this.defaultLogLevel = LogLoggerConfiguration.stringToLevel(defaultLogLevelString);
        }
        this.showLogName = this.getBooleanProperty(SHOW_LOG_NAME_KEY, this.showLogName);
        this.showShortLogName = this.getBooleanProperty(SHOW_SHORT_LOG_NAME_KEY, this.showShortLogName);
        this.showDateTime = this.getBooleanProperty(SHOW_DATE_TIME_KEY, this.showDateTime);
        this.showThreadName = this.getBooleanProperty(SHOW_THREAD_NAME_KEY, this.showThreadName);
        this.dateTimeFormatString = this.getStringProperty(DATE_TIME_FORMAT_KEY, this.dateTimeFormatString);
        if (this.dateTimeFormatString != null) {
            try {
                this.dateFormatter = new SimpleDateFormat(this.dateTimeFormatString);
            }
            catch (IllegalArgumentException e) {
                Util.report((String)MessageFormat.format("Bad date format [{0}] will output relative time", this.dateTimeFormatString), (Throwable)e);
            }
        }
    }

    LogLoggerConfiguration(Properties properties) {
        this.properties = (Properties)Validate.notNull((Object)properties);
        this.init();
    }

    private String recursivelyComputeLevelString(String name) {
        String tempName = name;
        String levelString = null;
        int indexOfLastDot = tempName.length();
        while (levelString == null && indexOfLastDot > -1) {
            tempName = tempName.substring(0, indexOfLastDot);
            levelString = this.getStringProperty(LOG_KEY_PREFIX + tempName, null);
            indexOfLastDot = String.valueOf(tempName).lastIndexOf(".");
        }
        return levelString;
    }

    private static int stringToLevel(String levelStr) {
        if ("trace".equalsIgnoreCase(levelStr)) {
            return 0;
        }
        if ("debug".equalsIgnoreCase(levelStr)) {
            return 10;
        }
        if ("info".equalsIgnoreCase(levelStr)) {
            return 20;
        }
        if ("warn".equalsIgnoreCase(levelStr)) {
            return 30;
        }
        if ("error".equalsIgnoreCase(levelStr)) {
            return 40;
        }
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedDate(Date now) {
        String dateText;
        DateFormat dateFormat = this.dateFormatter;
        synchronized (dateFormat) {
            dateText = this.dateFormatter.format(now);
        }
        return dateText;
    }

    public int getLogLevel(String name) {
        String levelString = this.recursivelyComputeLevelString(name);
        if (levelString != null) {
            return LogLoggerConfiguration.stringToLevel(levelString);
        }
        return this.defaultLogLevel;
    }

    public String getFormattedDateTime() {
        if (this.dateFormatter != null) {
            return this.getFormattedDate(new Date());
        }
        return Long.toString(System.currentTimeMillis() - this.startTime);
    }

    public boolean isShowDateTime() {
        return this.showDateTime;
    }

    public boolean isShowThreadName() {
        return this.showThreadName;
    }

    public boolean isShowShortLogName() {
        return this.showShortLogName;
    }

    public boolean isShowLogName() {
        return this.showLogName;
    }
}

