/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.maven.plugin.logging.slfj4;

import org.apache.maven.plugin.logging.Log;
import org.hisrc.maven.plugin.logging.slfj4.LogLoggerConfiguration;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class LogLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -1330122643950450284L;
    public static final int LOG_LEVEL_TRACE = 0;
    public static final int LOG_LEVEL_DEBUG = 10;
    public static final int LOG_LEVEL_INFO = 20;
    public static final int LOG_LEVEL_WARN = 30;
    public static final int LOG_LEVEL_ERROR = 40;
    private final int currentLogLevel;
    private transient String shortLogName = null;
    private final Log log;
    private final LogLoggerConfiguration configuration;
    private final String name;

    LogLogger(Log log, LogLoggerConfiguration configuration, int level, String name) {
        this.log = log;
        this.configuration = configuration;
        this.name = name;
        this.currentLogLevel = level;
    }

    private void log(int level, String message, Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuffer buf = new StringBuffer(32);
        if (this.configuration.isShowDateTime()) {
            buf.append(this.configuration.getFormattedDateTime());
            buf.append(' ');
        }
        if (this.configuration.isShowThreadName()) {
            buf.append('[');
            buf.append(Thread.currentThread().getName());
            buf.append("] ");
        }
        if (this.configuration.isShowShortLogName()) {
            if (this.shortLogName == null) {
                this.shortLogName = this.computeShortName();
            }
            buf.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (this.configuration.isShowLogName()) {
            buf.append(String.valueOf(this.name)).append(" - ");
        }
        buf.append(message);
        this.write(level, buf, t);
    }

    void write(int level, StringBuffer buf, Throwable t) {
        switch (level) {
            case 0: {
                if (t == null) {
                    this.log.debug((CharSequence)buf.toString());
                    break;
                }
                this.log.debug((CharSequence)buf.toString(), t);
                break;
            }
            case 10: {
                if (t == null) {
                    this.log.debug((CharSequence)buf.toString());
                    break;
                }
                this.log.debug((CharSequence)buf.toString(), t);
                break;
            }
            case 20: {
                if (t == null) {
                    this.log.info((CharSequence)buf.toString());
                    break;
                }
                this.log.info((CharSequence)buf.toString(), t);
                break;
            }
            case 30: {
                if (t == null) {
                    this.log.warn((CharSequence)buf.toString());
                    break;
                }
                this.log.warn((CharSequence)buf.toString(), t);
                break;
            }
            case 40: {
                if (t == null) {
                    this.log.error((CharSequence)buf.toString());
                    break;
                }
                this.log.error((CharSequence)buf.toString(), t);
            }
        }
    }

    private String computeShortName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    private void formatAndLog(int level, String format, Object arg1, Object arg2) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private void formatAndLog(int level, String format, Object ... arguments) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public void trace(String msg) {
        this.log(0, msg, null);
    }

    public void trace(String format, Object param1) {
        this.formatAndLog(0, format, param1, (Object)null);
    }

    public void trace(String format, Object param1, Object param2) {
        this.formatAndLog(0, format, param1, param2);
    }

    public void trace(String format, Object ... argArray) {
        this.formatAndLog(0, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    public void debug(String msg) {
        this.log(10, msg, null);
    }

    public void debug(String format, Object param1) {
        this.formatAndLog(10, format, param1, (Object)null);
    }

    public void debug(String format, Object param1, Object param2) {
        this.formatAndLog(10, format, param1, param2);
    }

    public void debug(String format, Object ... argArray) {
        this.formatAndLog(10, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(10, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    public void info(String msg) {
        this.log(20, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(20, format, arg, (Object)null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(20, format, arg1, arg2);
    }

    public void info(String format, Object ... argArray) {
        this.formatAndLog(20, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(20, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    public void warn(String msg) {
        this.log(30, msg, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(30, format, arg, (Object)null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(30, format, arg1, arg2);
    }

    public void warn(String format, Object ... argArray) {
        this.formatAndLog(30, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(30, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    public void error(String msg) {
        this.log(40, msg, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(40, format, arg, (Object)null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(40, format, arg1, arg2);
    }

    public void error(String format, Object ... argArray) {
        this.formatAndLog(40, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(40, msg, t);
    }
}

