/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.parser.TokenQueue;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector {
    private static final String[] combinators = new String[]{",", ">", "+", "~", " "};
    private final Element root;
    private final LinkedHashSet<Element> elements;
    private final String query;
    private final TokenQueue tq;

    private Selector(String query, Element root) {
        Validate.notNull(query);
        query = query.trim();
        Validate.notEmpty(query);
        Validate.notNull(root);
        this.elements = new LinkedHashSet();
        this.query = query;
        this.root = root;
        this.tq = new TokenQueue(query);
    }

    public static Elements select(String query, Element root) {
        return new Selector(query, root).select();
    }

    public static Elements select(String query, Iterable<Element> roots) {
        Validate.notEmpty(query);
        Validate.notNull(roots);
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        for (Element root : roots) {
            elements.addAll(Selector.select(query, root));
        }
        return new Elements(elements);
    }

    private Elements select() {
        this.tq.consumeWhitespace();
        if (this.tq.matchesAny(combinators)) {
            this.elements.add(this.root);
            this.combinator(this.tq.consume().toString());
        } else if (this.tq.matches(":has(")) {
            this.elements.addAll(this.root.getAllElements());
        } else {
            this.addElements(this.findElements());
        }
        while (!this.tq.isEmpty()) {
            boolean seenWhite = this.tq.consumeWhitespace();
            if (this.tq.matchChomp(",")) {
                while (!this.tq.isEmpty()) {
                    String subQuery = this.tq.chompTo(",");
                    this.elements.addAll(Selector.select(subQuery, this.root));
                }
                continue;
            }
            if (this.tq.matchesAny(combinators)) {
                this.combinator(this.tq.consume().toString());
                continue;
            }
            if (seenWhite) {
                this.combinator(" ");
                continue;
            }
            Elements candidates = this.findElements();
            this.intersectElements(Selector.filterForSelf(this.elements, candidates));
        }
        return new Elements(this.elements);
    }

    private void combinator(String combinator) {
        Elements output;
        this.tq.consumeWhitespace();
        String subQuery = this.tq.consumeToAny(combinators);
        if (combinator.equals(">")) {
            output = Selector.filterForChildren(this.elements, Selector.select(subQuery, this.elements));
        } else if (combinator.equals(" ")) {
            output = Selector.filterForDescendants(this.elements, Selector.select(subQuery, this.elements));
        } else if (combinator.equals("+")) {
            output = Selector.filterForAdjacentSiblings(this.elements, Selector.select(subQuery, this.root));
        } else if (combinator.equals("~")) {
            output = Selector.filterForGeneralSiblings(this.elements, Selector.select(subQuery, this.root));
        } else {
            throw new IllegalStateException("Unknown combinator: " + combinator);
        }
        this.elements.clear();
        this.elements.addAll(output);
    }

    private Elements findElements() {
        if (this.tq.matchChomp("#")) {
            return this.byId();
        }
        if (this.tq.matchChomp(".")) {
            return this.byClass();
        }
        if (this.tq.matchesWord()) {
            return this.byTag();
        }
        if (this.tq.matches("[")) {
            return this.byAttribute();
        }
        if (this.tq.matchChomp("*")) {
            return this.allElements();
        }
        if (this.tq.matchChomp(":lt(")) {
            return this.indexLessThan();
        }
        if (this.tq.matchChomp(":gt(")) {
            return this.indexGreaterThan();
        }
        if (this.tq.matchChomp(":eq(")) {
            return this.indexEquals();
        }
        if (this.tq.matches(":has(")) {
            return this.has();
        }
        if (this.tq.matches(":contains(")) {
            return this.contains(false);
        }
        if (this.tq.matches(":containsOwn(")) {
            return this.contains(true);
        }
        if (this.tq.matches(":matches(")) {
            return this.matches(false);
        }
        if (this.tq.matches(":matchesOwn(")) {
            return this.matches(true);
        }
        if (this.tq.matches(":not(")) {
            return this.not();
        }
        throw new SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
    }

    private void addElements(Collection<Element> add) {
        this.elements.addAll(add);
    }

    private void intersectElements(Collection<Element> intersect) {
        this.elements.retainAll(intersect);
    }

    private Elements byId() {
        String id = this.tq.consumeCssIdentifier();
        Validate.notEmpty(id);
        Element found = this.root.getElementById(id);
        Elements byId = new Elements();
        if (found != null) {
            byId.add(found);
        }
        return byId;
    }

    private Elements byClass() {
        String className = this.tq.consumeCssIdentifier();
        Validate.notEmpty(className);
        return this.root.getElementsByClass(className);
    }

    private Elements byTag() {
        String tagName = this.tq.consumeElementSelector();
        Validate.notEmpty(tagName);
        if (tagName.contains("|")) {
            tagName = tagName.replace("|", ":");
        }
        return this.root.getElementsByTag(tagName);
    }

    private Elements byAttribute() {
        TokenQueue cq = new TokenQueue(this.tq.chompBalanced(Character.valueOf('['), Character.valueOf(']')));
        String key = cq.consumeToAny("=", "!=", "^=", "$=", "*=", "~=");
        Validate.notEmpty(key);
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            return key.startsWith("^") ? this.root.getElementsByAttributeStarting(key.substring(1)) : this.root.getElementsByAttribute(key);
        }
        if (cq.matchChomp("=")) {
            return this.root.getElementsByAttributeValue(key, cq.remainder());
        }
        if (cq.matchChomp("!=")) {
            return this.root.getElementsByAttributeValueNot(key, cq.remainder());
        }
        if (cq.matchChomp("^=")) {
            return this.root.getElementsByAttributeValueStarting(key, cq.remainder());
        }
        if (cq.matchChomp("$=")) {
            return this.root.getElementsByAttributeValueEnding(key, cq.remainder());
        }
        if (cq.matchChomp("*=")) {
            return this.root.getElementsByAttributeValueContaining(key, cq.remainder());
        }
        if (cq.matchChomp("~=")) {
            return this.root.getElementsByAttributeValueMatching(key, cq.remainder());
        }
        throw new SelectorParseException("Could not parse attribute query '%s': unexpected token at '%s'", this.query, cq.remainder());
    }

    private Elements allElements() {
        return this.root.getAllElements();
    }

    private Elements indexLessThan() {
        return this.root.getElementsByIndexLessThan(this.consumeIndex());
    }

    private Elements indexGreaterThan() {
        return this.root.getElementsByIndexGreaterThan(this.consumeIndex());
    }

    private Elements indexEquals() {
        return this.root.getElementsByIndexEquals(this.consumeIndex());
    }

    private int consumeIndex() {
        String indexS = this.tq.chompTo(")").trim();
        Validate.isTrue(StringUtil.isNumeric(indexS), "Index must be numeric");
        return Integer.parseInt(indexS);
    }

    private Elements has() {
        this.tq.consume(":has");
        String subQuery = this.tq.chompBalanced(Character.valueOf('('), Character.valueOf(')'));
        Validate.notEmpty(subQuery, ":has(el) subselect must not be empty");
        return Selector.filterForParentsOfDescendants(this.elements, Selector.select(subQuery, this.elements));
    }

    private Elements contains(boolean own) {
        this.tq.consume(own ? ":containsOwn" : ":contains");
        String searchText = TokenQueue.unescape(this.tq.chompBalanced(Character.valueOf('('), Character.valueOf(')')));
        Validate.notEmpty(searchText, ":contains(text) query must not be empty");
        return own ? this.root.getElementsContainingOwnText(searchText) : this.root.getElementsContainingText(searchText);
    }

    private Elements matches(boolean own) {
        this.tq.consume(own ? ":matchesOwn" : ":matches");
        String regex = this.tq.chompBalanced(Character.valueOf('('), Character.valueOf(')'));
        Validate.notEmpty(regex, ":matches(regex) query must not be empty");
        return own ? this.root.getElementsMatchingOwnText(regex) : this.root.getElementsMatchingText(regex);
    }

    private Elements not() {
        this.tq.consume(":not");
        String subQuery = this.tq.chompBalanced(Character.valueOf('('), Character.valueOf(')'));
        Validate.notEmpty(subQuery, ":not(selector) subselect must not be empty");
        return Selector.filterOut(this.root.getAllElements(), Selector.select(subQuery, this.root));
    }

    private static Elements filterForChildren(Collection<Element> parents, Collection<Element> candidates) {
        Elements children = new Elements();
        block0: for (Element c : candidates) {
            for (Element p : parents) {
                if (c.parent() == null || !c.parent().equals(p)) continue;
                children.add(c);
                continue block0;
            }
        }
        return children;
    }

    private static Elements filterForDescendants(Collection<Element> parents, Collection<Element> candidates) {
        Elements children = new Elements();
        block0: for (Element c : candidates) {
            for (Element p : parents) {
                if (!c.equals(p)) continue;
                continue block0;
            }
            children.add(c);
        }
        return children;
    }

    private static Elements filterForParentsOfDescendants(Collection<Element> parents, Collection<Element> children) {
        Elements filteredParents = new Elements();
        for (Element p : parents) {
            for (Element c : children) {
                if (!c.parents().contains(p)) continue;
                filteredParents.add(p);
            }
        }
        return filteredParents;
    }

    private static Elements filterForAdjacentSiblings(Collection<Element> elements, Collection<Element> candidates) {
        Elements siblings = new Elements();
        block0: for (Element c : candidates) {
            for (Element e : elements) {
                Element previousSib;
                if (!e.parent().equals(c.parent()) || (previousSib = c.previousElementSibling()) == null || !previousSib.equals(e)) continue;
                siblings.add(c);
                continue block0;
            }
        }
        return siblings;
    }

    private static Elements filterForGeneralSiblings(Collection<Element> elements, Collection<Element> candidates) {
        Elements output = new Elements();
        block0: for (Element c : candidates) {
            for (Element e : elements) {
                if (!e.parent().equals(c.parent())) continue;
                int ePos = e.elementSiblingIndex();
                int cPos = c.elementSiblingIndex();
                if (cPos <= ePos) continue;
                output.add(c);
                continue block0;
            }
        }
        return output;
    }

    private static Elements filterForSelf(Collection<Element> parents, Collection<Element> candidates) {
        Elements children = new Elements();
        block0: for (Element c : candidates) {
            for (Element p : parents) {
                if (!c.equals(p)) continue;
                children.add(c);
                continue block0;
            }
        }
        return children;
    }

    static Elements filterOut(Collection<Element> elements, Collection<Element> outs) {
        Elements output = new Elements();
        for (Element el : elements) {
            boolean found = false;
            for (Element out : outs) {
                if (!el.equals(out)) continue;
                found = true;
                break;
            }
            if (found) continue;
            output.add(el);
        }
        return output;
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String msg, Object ... params) {
            super(String.format(msg, params));
        }
    }
}

