/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;

public class TokenQueue {
    private String queue;
    private int pos = 0;
    private static final Character ESC = Character.valueOf('\\');

    public TokenQueue(String data) {
        Validate.notNull(data);
        this.queue = data;
    }

    public boolean isEmpty() {
        return this.remainingLength() == 0;
    }

    private int remainingLength() {
        return this.queue.length() - this.pos;
    }

    public Character peek() {
        return this.isEmpty() ? null : Character.valueOf(this.queue.charAt(this.pos));
    }

    public void addFirst(Character c) {
        this.addFirst(c.toString());
    }

    public void addFirst(String seq) {
        this.queue = seq + this.queue.substring(this.pos);
        this.pos = 0;
    }

    public boolean matches(String seq) {
        int count = seq.length();
        if (count > this.remainingLength()) {
            return false;
        }
        while (--count >= 0) {
            if (Character.toLowerCase(seq.charAt(count)) == Character.toLowerCase(this.queue.charAt(this.pos + count))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesCS(String seq) {
        return this.queue.startsWith(seq, this.pos);
    }

    public boolean matchesAny(String ... seq) {
        for (String s : seq) {
            if (!this.matches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        for (char c : seq) {
            if (this.queue.charAt(this.pos) != c) continue;
            return true;
        }
        return false;
    }

    public boolean matchesStartTag() {
        return this.remainingLength() >= 2 && this.queue.charAt(this.pos) == '<' && Character.isLetterOrDigit(this.queue.charAt(this.pos + 1));
    }

    public boolean matchChomp(String seq) {
        if (this.matches(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && Character.isWhitespace(this.queue.charAt(this.pos));
    }

    public boolean matchesWord() {
        return !this.isEmpty() && Character.isLetterOrDigit(this.queue.charAt(this.pos));
    }

    public void advance() {
        if (!this.isEmpty()) {
            ++this.pos;
        }
    }

    public Character consume() {
        Character c = Character.valueOf(this.queue.charAt(this.pos));
        ++this.pos;
        return c;
    }

    public void consume(String seq) {
        if (!this.matches(seq)) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
        int len = seq.length();
        if (len > this.remainingLength()) {
            throw new IllegalStateException("Queue not long enough to consume sequence");
        }
        this.pos += len;
    }

    public String consumeTo(String seq) {
        int offset = this.queue.indexOf(seq, this.pos);
        if (offset != -1) {
            String consumed = this.queue.substring(this.pos, offset);
            this.pos += consumed.length();
            return consumed;
        }
        return this.remainder();
    }

    public String consumeToIgnoreCase(String seq) {
        int start = this.pos;
        String first = seq.substring(0, 1);
        boolean canScan = first.toLowerCase().equals(first.toUpperCase());
        while (!this.isEmpty() && !this.matches(seq)) {
            if (canScan) {
                int skip = this.queue.indexOf(first, this.pos) - this.pos;
                if (skip <= 0) {
                    ++this.pos;
                    continue;
                }
                if (skip < 0) {
                    this.pos = this.queue.length() - 1;
                    continue;
                }
                this.pos += skip;
                continue;
            }
            ++this.pos;
        }
        String data = this.queue.substring(start, this.pos);
        return data;
    }

    public String consumeToAny(String ... seq) {
        int start = this.pos;
        while (!this.isEmpty() && !this.matchesAny(seq)) {
            ++this.pos;
        }
        String data = this.queue.substring(start, this.pos);
        return data;
    }

    public String chompTo(String seq) {
        String data = this.consumeTo(seq);
        this.matchChomp(seq);
        return data;
    }

    public String chompToIgnoreCase(String seq) {
        String data = this.consumeToIgnoreCase(seq);
        this.matchChomp(seq);
        return data;
    }

    public String chompBalanced(Character open, Character close) {
        StringBuilder accum = new StringBuilder();
        int depth = 0;
        Character last = null;
        while (!this.isEmpty()) {
            Character c = this.consume();
            if (last == null || !last.equals(ESC)) {
                if (c.equals(open)) {
                    ++depth;
                } else if (c.equals(close)) {
                    --depth;
                }
            }
            if (depth > 0 && last != null) {
                accum.append(c);
            }
            last = c;
            if (depth > 0) continue;
        }
        return accum.toString();
    }

    public static String unescape(String in) {
        StringBuilder out = new StringBuilder();
        Character last = null;
        char[] arr$ = in.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (c.equals(ESC)) {
                if (last != null && last.equals(ESC)) {
                    out.append(c);
                }
            } else {
                out.append(c);
            }
            last = c;
        }
        return out.toString();
    }

    public boolean consumeWhitespace() {
        boolean seen = false;
        while (this.matchesWhitespace()) {
            ++this.pos;
            seen = true;
        }
        return seen;
    }

    public String consumeWord() {
        int start = this.pos;
        while (this.matchesWord()) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeTagName() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny(':', '_', '-'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeElementSelector() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('|', '_', '-'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeCssIdentifier() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeAttributeKey() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_', ':'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String remainder() {
        StringBuilder accum = new StringBuilder();
        while (!this.isEmpty()) {
            accum.append(this.consume());
        }
        return accum.toString();
    }

    public String toString() {
        return this.queue.substring(this.pos);
    }
}

