/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.script;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Invocation;

public class ScriptedAction
implements Action {
    private final Interpreter interpreter = new Interpreter();
    private final String script;

    public ScriptedAction(String expression) {
        this.script = expression;
        this.interpreter.setStrictJava(true);
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        try {
            this.defineParameters(this.interpreter, invocation);
            return this.interpreter.eval(this.script);
        }
        catch (TargetError e) {
            throw e.getTarget();
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("could not interpret script", e);
        }
    }

    private void defineParameters(Interpreter interpreter, Invocation invocation) throws EvalError {
        interpreter.set("$this", invocation.getInvokedObject());
        for (int i = 0; i < invocation.getParameterCount(); ++i) {
            interpreter.set("$" + i, invocation.getParameter(i));
        }
    }

    public void describeTo(Description description) {
        description.appendText("perform ").appendText(this.script);
    }

    public static ScriptedAction perform(String script) {
        return new ScriptedAction(script);
    }

    public ScriptedAction where(String name, Object value) {
        try {
            this.interpreter.set(name, value);
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("invalid name binding", e);
        }
        return this;
    }
}

