/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jmock.lib.concurrent.UnsupportedSynchronousOperationException;
import org.jmock.lib.concurrent.internal.DeltaQueue;

public class DeterministicScheduler
implements ScheduledExecutorService {
    private final DeltaQueue<ScheduledTask<?>> deltaQueue = new DeltaQueue();

    public void tick(long duration, TimeUnit timeUnit) {
        long remaining = this.toTicks(duration, timeUnit);
        do {
            remaining = this.deltaQueue.tick(remaining);
            this.runUntilIdle();
        } while (this.deltaQueue.isNotEmpty() && remaining > 0L);
    }

    public void runUntilIdle() {
        while (!this.isIdle()) {
            this.runNextPendingCommand();
        }
    }

    public void runNextPendingCommand() {
        ScheduledTask<?> scheduledTask = this.deltaQueue.pop();
        scheduledTask.run();
        if (!scheduledTask.isCancelled() && scheduledTask.repeats()) {
            this.deltaQueue.add(scheduledTask.repeatDelay, scheduledTask);
        }
    }

    public boolean isIdle() {
        return this.deltaQueue.isEmpty() || this.deltaQueue.delay() > 0L;
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.SECONDS);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledTask task = new ScheduledTask(command);
        this.deltaQueue.add(this.toTicks(delay, unit), task);
        return task;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTask<V> task = new ScheduledTask<V>(callable);
        this.deltaQueue.add(this.toTicks(delay, unit), task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledTask task = new ScheduledTask(this.toTicks(delay, unit), command);
        this.deltaQueue.add(this.toTicks(initialDelay, unit), task);
        return task;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw this.blockingOperationsNotSupported();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw this.blockingOperationsNotSupported();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw this.blockingOperationsNotSupported();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw this.blockingOperationsNotSupported();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw this.blockingOperationsNotSupported();
    }

    @Override
    public boolean isShutdown() {
        throw this.shutdownNotSupported();
    }

    @Override
    public boolean isTerminated() {
        throw this.shutdownNotSupported();
    }

    @Override
    public void shutdown() {
        throw this.shutdownNotSupported();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw this.shutdownNotSupported();
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.schedule(callable, 0L, TimeUnit.SECONDS);
    }

    @Override
    public Future<?> submit(Runnable command) {
        return this.submit(command, null);
    }

    @Override
    public <T> Future<T> submit(Runnable command, T result) {
        return this.submit(new CallableRunnableAdapter<T>(command, result));
    }

    private long toTicks(long duration, TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(duration, timeUnit);
    }

    private UnsupportedSynchronousOperationException blockingOperationsNotSupported() {
        return new UnsupportedSynchronousOperationException("cannot perform blocking wait on a task scheduled on a " + DeterministicScheduler.class.getName());
    }

    private UnsupportedOperationException shutdownNotSupported() {
        return new UnsupportedOperationException("shutdown not supported");
    }

    private final class ScheduledTask<T>
    implements ScheduledFuture<T>,
    Runnable {
        public final long repeatDelay;
        public final Callable<T> command;
        private boolean isCancelled = false;
        private boolean isDone = false;
        private T futureResult;
        private Exception failure = null;

        public ScheduledTask(Callable<T> command) {
            this.repeatDelay = -1L;
            this.command = command;
        }

        public ScheduledTask(Runnable command) {
            this(-1L, command);
        }

        public ScheduledTask(long repeatDelay, Runnable command) {
            this.repeatDelay = repeatDelay;
            this.command = new CallableRunnableAdapter<Object>(command, null);
        }

        public String toString() {
            return this.command.toString() + " repeatDelay=" + this.repeatDelay;
        }

        public boolean repeats() {
            return this.repeatDelay >= 0L;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(DeterministicScheduler.this.deltaQueue.delay(this), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelled = true;
            return DeterministicScheduler.this.deltaQueue.remove(this);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (!this.isDone) {
                throw DeterministicScheduler.this.blockingOperationsNotSupported();
            }
            if (this.failure != null) {
                throw new ExecutionException(this.failure);
            }
            return this.futureResult;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public void run() {
            try {
                this.futureResult = this.command.call();
            }
            catch (Exception e) {
                this.failure = e;
            }
            this.isDone = true;
        }
    }

    private final class CallableRunnableAdapter<T>
    implements Callable<T> {
        private final Runnable runnable;
        private final T result;

        public CallableRunnableAdapter(Runnable runnable, T result) {
            this.runnable = runnable;
            this.result = result;
        }

        public String toString() {
            return this.runnable.toString();
        }

        @Override
        public T call() throws Exception {
            this.runnable.run();
            return this.result;
        }
    }
}

