/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib;

import org.jmock.api.MockObjectNamingScheme;

public class CamelCaseNamingScheme
implements MockObjectNamingScheme {
    public static final CamelCaseNamingScheme INSTANCE = new CamelCaseNamingScheme();

    @Override
    public String defaultNameFor(Class<?> typeToMock) {
        String simpleName = typeToMock.getSimpleName();
        int lci = this.indexOfFirstLowerCaseLetter(simpleName);
        if (lci == 0) {
            return simpleName;
        }
        int capsEnd = lci == 1 || lci == simpleName.length() ? lci : lci - 1;
        String caps = simpleName.substring(0, capsEnd);
        String rest = simpleName.substring(capsEnd);
        return caps.toLowerCase() + rest;
    }

    private int indexOfFirstLowerCaseLetter(String simpleName) {
        int i;
        for (i = 0; i < simpleName.length() && !Character.isLowerCase(simpleName.charAt(i)); ++i) {
        }
        return i;
    }
}

