/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.util.ConcurrentModificationException;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.api.ThreadingPolicy;
import org.jmock.lib.concurrent.Synchroniser;

public class SingleThreadedPolicy
implements ThreadingPolicy {
    private final Thread testThread = Thread.currentThread();

    @Override
    public Invokable synchroniseAccessTo(final Invokable mockObject) {
        return new Invokable(){

            @Override
            public Object invoke(Invocation invocation) throws Throwable {
                SingleThreadedPolicy.this.checkRunningOnTestThread();
                return mockObject.invoke(invocation);
            }
        };
    }

    private void checkRunningOnTestThread() {
        if (Thread.currentThread() != this.testThread) {
            this.reportError("the Mockery is not thread-safe: use a " + Synchroniser.class.getSimpleName() + " to ensure thread safety");
        }
    }

    private void reportError(String error) {
        System.err.println(error);
        throw new ConcurrentModificationException(error);
    }
}

