/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.jmock.Sequence;
import org.jmock.api.Expectation;
import org.jmock.internal.InvocationExpectation;
import org.jmock.internal.OrderingConstraint;

public class NamedSequence
implements Sequence {
    private final String name;
    private List<Expectation> elements = new ArrayList<Expectation>();

    public NamedSequence(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void constrainAsNextInSequence(InvocationExpectation expectation) {
        int index = this.elements.size();
        this.elements.add(expectation);
        expectation.addOrderingConstraint(new InSequenceOrderingConstraint(this, index));
    }

    private boolean isSatisfiedToIndex(int index) {
        for (int i = 0; i < index; ++i) {
            if (this.elements.get(i).isSatisfied()) continue;
            return false;
        }
        return true;
    }

    private static class InSequenceOrderingConstraint
    implements OrderingConstraint {
        private final NamedSequence sequence;
        private final int index;

        public InSequenceOrderingConstraint(NamedSequence sequence, int index) {
            this.sequence = sequence;
            this.index = index;
        }

        @Override
        public boolean allowsInvocationNow() {
            return this.sequence.isSatisfiedToIndex(this.index);
        }

        public void describeTo(Description description) {
            description.appendText("in sequence ").appendText(this.sequence.name);
        }
    }
}

