/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;

public abstract class FakeObjectMethods
implements Invokable {
    private final Invokable next;

    public FakeObjectMethods(Invokable next) {
        this.next = next;
    }

    public String toString() {
        return this.next.toString();
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        Method method = invocation.getInvokedMethod();
        if (this.isMethod(method, Integer.TYPE, "hashCode", new Class[0])) {
            return this.fakeHashCode(invocation.getInvokedObject());
        }
        if (this.isMethod(method, String.class, "toString", new Class[0])) {
            return this.fakeToString(invocation.getInvokedObject());
        }
        if (this.isMethod(method, Boolean.TYPE, "equals", Object.class)) {
            return this.fakeEquals(invocation.getInvokedObject(), invocation.getParameter(0));
        }
        if (this.isMethod(method, Void.TYPE, "finalize", new Class[0])) {
            this.fakeFinalize(invocation.getInvokedObject());
            return null;
        }
        return this.next.invoke(invocation);
    }

    protected abstract int fakeHashCode(Object var1);

    protected abstract String fakeToString(Object var1);

    protected abstract boolean fakeEquals(Object var1, Object var2);

    protected abstract void fakeFinalize(Object var1);

    private boolean isMethod(Method method, Class<?> returnType, String name, Class<?> ... parameterTypes) {
        return method.getReturnType().equals(returnType) && method.getName().equals(name) && Arrays.equals(method.getParameterTypes(), parameterTypes);
    }
}

