/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.concurrent.internal;

import java.util.concurrent.TimeoutException;
import org.jmock.lib.concurrent.internal.Timeout;

public class FixedTimeout
implements Timeout {
    private final long duration;
    private final long start;

    public FixedTimeout(long duration) {
        this.duration = duration;
        this.start = System.currentTimeMillis();
    }

    public long timeRemaining() throws TimeoutException {
        long now = System.currentTimeMillis();
        long timeLeft = this.duration - (now - this.start);
        if (timeLeft <= 0L) {
            throw new TimeoutException("timed out after " + this.duration + " ms");
        }
        return timeLeft;
    }
}

