/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jmock.States;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentStateMatcher
extends TypeSafeMatcher<States> {
    private final String stateName;
    private final boolean expected;

    public CurrentStateMatcher(String stateName, boolean expected) {
        this.expected = expected;
        this.stateName = stateName;
    }

    public boolean matchesSafely(States stateMachine) {
        return stateMachine.is(this.stateName).isActive() == this.expected;
    }

    protected void describeMismatchSafely(States stateMachine, Description mismatchDescription) {
        mismatchDescription.appendText("was ");
        if (!stateMachine.is(this.stateName).isActive()) {
            mismatchDescription.appendText("not ");
        }
        mismatchDescription.appendText(this.stateName);
    }

    public void describeTo(Description description) {
        description.appendText("a state machine that ").appendText(this.expected ? "is " : "is not ").appendText(this.stateName);
    }

    @Factory
    public static Matcher<States> isCurrently(String stateName) {
        return new CurrentStateMatcher(stateName, true);
    }

    @Factory
    public static Matcher<States> isNotCurrently(String stateName) {
        return new CurrentStateMatcher(stateName, false);
    }
}

