/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal.matcher;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsEqual;
import org.jmock.internal.ParametersMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllParametersMatcher
extends TypeSafeDiagnosingMatcher<Object[]>
implements ParametersMatcher {
    private final Matcher<Object>[] elementMatchers;

    public AllParametersMatcher(Object[] expectedValues) {
        this.elementMatchers = AllParametersMatcher.equalMatchersFor(expectedValues);
    }

    public AllParametersMatcher(List<Matcher<?>> parameterMatchers) {
        this.elementMatchers = parameterMatchers.toArray(new Matcher[0]);
    }

    @Override
    public boolean isCompatibleWith(Object[] parameters) {
        return this.elementMatchers.length == parameters.length;
    }

    public boolean matchesSafely(Object[] parameters, Description mismatch) {
        return this.matchesNumberOfParameters(parameters, mismatch) && this.matchesParameters(parameters, mismatch);
    }

    private boolean matchesNumberOfParameters(Object[] parameters, Description mismatch) {
        if (this.elementMatchers.length != parameters.length) {
            mismatch.appendText("wrong number of parameters: ").appendValue((Object)parameters);
            return false;
        }
        return true;
    }

    private boolean matchesParameters(Object[] parameters, Description mismatch) {
        boolean result = true;
        for (int i = 0; i < parameters.length; ++i) {
            result &= this.matchesParameter(parameters[i], this.elementMatchers[i], mismatch, i);
        }
        return result;
    }

    private boolean matchesParameter(Object value, Matcher<Object> matcher, Description mismatch, int index) {
        mismatch.appendText("\n      parameter " + index + " ");
        boolean parameterMatches = matcher.matches(value);
        if (parameterMatches) {
            mismatch.appendText("matched: ").appendDescriptionOf(matcher);
        } else {
            mismatch.appendText("did not match: ").appendDescriptionOf(matcher).appendText(", because ");
            matcher.describeMismatch(value, mismatch);
        }
        return parameterMatches;
    }

    public void describeTo(Description description) {
        description.appendList("(", ", ", ")", Arrays.asList(this.elementMatchers));
    }

    private static Matcher<Object>[] equalMatchersFor(Object[] expectedValues) {
        Matcher[] matchers = new Matcher[expectedValues.length];
        for (int i = 0; i < expectedValues.length; ++i) {
            matchers[i] = new IsEqual(expectedValues[i]);
        }
        return matchers;
    }
}

