/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.beans.beancontext.BeanContextServicesSupport;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.lib.JavaReflectionImposteriser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnDefaultValueAction
implements Action {
    private static final Class<?>[] COLLECTION_MAP_TYPES = new Class[]{LinkedList.class, TreeSet.class, TreeMap.class, BeanContextServicesSupport.class};
    private final Map<Class<?>, Object> resultValuesByType;
    private Imposteriser imposteriser;

    public ReturnDefaultValueAction(Imposteriser imposteriser, Map<Class<?>, Object> typeToResultValue) {
        this.imposteriser = imposteriser;
        this.resultValuesByType = typeToResultValue;
    }

    public ReturnDefaultValueAction(Imposteriser imposteriser) {
        this(imposteriser, ReturnDefaultValueAction.createDefaultResults());
    }

    public ReturnDefaultValueAction() {
        this(new JavaReflectionImposteriser());
    }

    public void setImposteriser(Imposteriser newImposteriser) {
        this.imposteriser = newImposteriser;
    }

    public void describeTo(Description description) {
        description.appendText("returns a default value");
    }

    public void addResult(Class<?> resultType, Object resultValue) {
        this.resultValuesByType.put(resultType, resultValue);
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        Object instance;
        Class<?> returnType = invocation.getInvokedMethod().getReturnType();
        if (this.resultValuesByType.containsKey(returnType)) {
            return this.resultValuesByType.get(returnType);
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if (this.isCollectionOrMap(returnType) && (instance = this.collectionOrMapInstanceFor(returnType)) != null) {
            return instance;
        }
        if (this.imposteriser.canImposterise(returnType)) {
            return this.imposteriser.imposterise(this, returnType, new Class[0]);
        }
        return null;
    }

    private Object collectionOrMapInstanceFor(Class<?> returnType) throws Throwable {
        return returnType.isInterface() ? this.instanceForCollectionType(returnType) : returnType.newInstance();
    }

    private Object instanceForCollectionType(Class<?> type) throws Throwable {
        for (Class<?> collectionType : COLLECTION_MAP_TYPES) {
            if (!type.isAssignableFrom(collectionType)) continue;
            return collectionType.newInstance();
        }
        return null;
    }

    private boolean isCollectionOrMap(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    protected static Map<Class<?>, Object> createDefaultResults() {
        HashMap result = new HashMap();
        result.put(Boolean.TYPE, Boolean.FALSE);
        result.put(Void.TYPE, null);
        result.put(Byte.TYPE, (byte)0);
        result.put(Short.TYPE, (short)0);
        result.put(Integer.TYPE, 0);
        result.put(Long.TYPE, 0L);
        result.put(Character.TYPE, Character.valueOf('\u0000'));
        result.put(Float.TYPE, Float.valueOf(0.0f));
        result.put(Double.TYPE, 0.0);
        result.put(Boolean.class, Boolean.FALSE);
        result.put(Byte.class, (byte)0);
        result.put(Short.class, (short)0);
        result.put(Integer.class, 0);
        result.put(Long.class, 0L);
        result.put(Character.class, Character.valueOf('\u0000'));
        result.put(Float.class, Float.valueOf(0.0f));
        result.put(Double.class, 0.0);
        result.put(String.class, "");
        result.put(Object.class, new Object());
        return result;
    }
}

