/*
 * Decompiled with CFR 0.152.
 */
package org.jmock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.jmock.Sequence;
import org.jmock.States;
import org.jmock.api.Expectation;
import org.jmock.api.ExpectationError;
import org.jmock.api.ExpectationErrorTranslator;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.api.MockObjectNamingScheme;
import org.jmock.api.ThreadingPolicy;
import org.jmock.internal.CaptureControl;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.internal.ExpectationCapture;
import org.jmock.internal.InvocationDispatcher;
import org.jmock.internal.InvocationDiverter;
import org.jmock.internal.InvocationToExpectationTranslator;
import org.jmock.internal.NamedSequence;
import org.jmock.internal.ObjectMethodExpectationBouncer;
import org.jmock.internal.ProxiedObjectIdentity;
import org.jmock.internal.ReturnDefaultValueAction;
import org.jmock.internal.SingleThreadedPolicy;
import org.jmock.lib.CamelCaseNamingScheme;
import org.jmock.lib.IdentityExpectationErrorTranslator;
import org.jmock.lib.JavaReflectionImposteriser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mockery
implements SelfDescribing {
    private Imposteriser imposteriser = JavaReflectionImposteriser.INSTANCE;
    private ExpectationErrorTranslator expectationErrorTranslator = IdentityExpectationErrorTranslator.INSTANCE;
    private MockObjectNamingScheme namingScheme = CamelCaseNamingScheme.INSTANCE;
    private ThreadingPolicy threadingPolicy = new SingleThreadedPolicy();
    private final Set<String> mockNames = new HashSet<String>();
    private final ReturnDefaultValueAction defaultAction = new ReturnDefaultValueAction(this.imposteriser);
    private final List<Invocation> actualInvocations = new ArrayList<Invocation>();
    private final InvocationDispatcher dispatcher = new InvocationDispatcher();
    private Error firstError = null;

    public void setDefaultResultForType(Class<?> type, Object result) {
        this.defaultAction.addResult(type, result);
    }

    public void setImposteriser(Imposteriser imposteriser) {
        this.imposteriser = imposteriser;
        this.defaultAction.setImposteriser(imposteriser);
    }

    public void setNamingScheme(MockObjectNamingScheme namingScheme) {
        this.namingScheme = namingScheme;
    }

    public void setExpectationErrorTranslator(ExpectationErrorTranslator expectationErrorTranslator) {
        this.expectationErrorTranslator = expectationErrorTranslator;
    }

    public void setThreadingPolicy(ThreadingPolicy threadingPolicy) {
        this.threadingPolicy = threadingPolicy;
    }

    public <T> T mock(Class<T> typeToMock) {
        return this.mock(typeToMock, this.namingScheme.defaultNameFor(typeToMock));
    }

    public <T> T mock(Class<T> typeToMock, String name) {
        if (this.mockNames.contains(name)) {
            throw new IllegalArgumentException("a mock with name " + name + " already exists");
        }
        MockObject mock = new MockObject(typeToMock, name);
        this.mockNames.add(name);
        Invokable invokable = this.threadingPolicy.synchroniseAccessTo(new ProxiedObjectIdentity(new InvocationDiverter<MockObject>(CaptureControl.class, mock, mock)));
        return this.imposteriser.imposterise(invokable, typeToMock, CaptureControl.class);
    }

    public Sequence sequence(String name) {
        return new NamedSequence(name);
    }

    public States states(String name) {
        return this.dispatcher.newStateMachine(name);
    }

    public void checking(ExpectationBuilder expectations) {
        expectations.buildExpectations(this.defaultAction, this.dispatcher);
    }

    public void addExpectation(Expectation expectation) {
        this.dispatcher.add(expectation);
    }

    public void assertIsSatisfied() {
        if (this.firstError != null) {
            throw this.firstError;
        }
        if (!this.dispatcher.isSatisfied()) {
            throw this.expectationErrorTranslator.translate(ExpectationError.notAllSatisfied(this));
        }
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf((SelfDescribing)this.dispatcher);
        this.describeHistory(description);
    }

    private void describeMismatch(Invocation invocation, Description description) {
        this.dispatcher.describeMismatch(invocation, description);
        this.describeHistory(description);
    }

    private void describeHistory(Description description) {
        description.appendText("\nwhat happened before this:");
        ArrayList<Invocation> invocationsSoFar = new ArrayList<Invocation>(this.actualInvocations);
        if (invocationsSoFar.isEmpty()) {
            description.appendText(" nothing!");
        } else {
            description.appendList("\n  ", "\n  ", "\n", invocationsSoFar);
        }
    }

    private Object dispatch(Invocation invocation) throws Throwable {
        if (this.firstError != null) {
            throw this.firstError;
        }
        try {
            Object result = this.dispatcher.dispatch(invocation);
            this.actualInvocations.add(invocation);
            return result;
        }
        catch (ExpectationError e) {
            this.firstError = this.expectationErrorTranslator.translate(this.mismatchDescribing(e));
            this.firstError.setStackTrace(e.getStackTrace());
            throw this.firstError;
        }
        catch (Throwable t) {
            this.actualInvocations.add(invocation);
            throw t;
        }
    }

    private ExpectationError mismatchDescribing(final ExpectationError e) {
        ExpectationError filledIn = new ExpectationError(e.getMessage(), new SelfDescribing(){

            public void describeTo(Description description) {
                Mockery.this.describeMismatch(e.invocation, description);
            }
        }, e.invocation);
        filledIn.setStackTrace(e.getStackTrace());
        return filledIn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockObject
    implements Invokable,
    CaptureControl {
        private Class<?> mockedType;
        private String name;

        public MockObject(Class<?> mockedType, String name) {
            this.name = name;
            this.mockedType = mockedType;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Object invoke(Invocation invocation) throws Throwable {
            return Mockery.this.dispatch(invocation);
        }

        @Override
        public Object captureExpectationTo(ExpectationCapture capture) {
            return Mockery.this.imposteriser.imposterise(new ObjectMethodExpectationBouncer(new InvocationToExpectationTranslator(capture, Mockery.this.defaultAction)), this.mockedType, new Class[0]);
        }
    }
}

