/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Promise;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Failure detection protocol based on sockets connecting members")
public class FD_SOCK
extends Protocol
implements Runnable {
    private static final int NORMAL_TERMINATION = 9;
    private static final int ABNORMAL_TERMINATION = -1;
    @LocalAddress
    @Property(description="The NIC on which the ServerSocket should listen on. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"}, writable=false)
    InetAddress bind_addr = null;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr = null;
    @Property(description="Used to map the internal port (bind_port) to an external port. Only used if > 0", systemProperty={"jgroups.external_port"}, writable=false)
    protected int external_port = 0;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str = null;
    @Property(description="Timeout for getting socket cache from coordinator. Default is 1000 msec")
    long get_cache_timeout = 1000L;
    @Property(description="Interval for broadcasting suspect messages. Default is 5000 msec")
    long suspect_msg_interval = 5000L;
    @Property(description="Number of attempts coordinator is solicited for socket cache until we give up. Default is 3")
    int num_tries = 3;
    @Property(description="Start port for server socket. Default value of 0 picks a random port")
    int start_port = 0;
    @Property(description="Start port for client socket. Default value of 0 picks a random port")
    int client_bind_port = 0;
    @Property(description="Number of ports to probe for start_port and client_bind_port")
    int port_range = 50;
    @Property(description="Whether to use KEEP_ALIVE on the ping socket or not. Default is true")
    private boolean keep_alive = true;
    @Property(description="Max time in millis to wait for ping Socket.connect() to return")
    private int sock_conn_timeout = 1000;
    private int num_suspect_events = 0;
    private final BoundedList<Address> suspect_history = new BoundedList(20);
    private volatile List<Address> members = new ArrayList<Address>(11);
    protected final Set<Address> suspected_mbrs = new CopyOnWriteArraySet<Address>();
    private final List<Address> pingable_mbrs = new CopyOnWriteArrayList<Address>();
    volatile boolean srv_sock_sent = false;
    private final Promise<Map<Address, IpAddress>> get_cache_promise = new Promise();
    private volatile boolean got_cache_from_coord = false;
    private Address local_addr = null;
    private ServerSocket srv_sock = null;
    private ServerSocketHandler srv_sock_handler = null;
    private IpAddress srv_sock_addr = null;
    private Address ping_dest = null;
    private Socket ping_sock = null;
    private InputStream ping_input = null;
    private volatile Thread pinger_thread = null;
    private final ConcurrentMap<Address, IpAddress> cache = Util.createConcurrentMap(11);
    private final Promise<IpAddress> ping_addr_promise = new Promise();
    private final Object sock_mutex = new Object();
    private TimeScheduler timer = null;
    private final BroadcastTask bcast_task = new BroadcastTask();
    private volatile boolean regular_sock_close = false;
    private boolean log_suspected_msgs = true;

    @ManagedAttribute(description="Member address")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute(description="List of cluster members")
    public String getMembers() {
        return this.members.toString();
    }

    @ManagedAttribute(description="List of pingable members of a cluster")
    public String getPingableMembers() {
        return this.pingable_mbrs.toString();
    }

    @ManagedAttribute(description="Ping destination")
    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    @ManagedAttribute(description="Number of suspect event generated")
    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public boolean isLogSuspectedMessages() {
        return this.log_suspected_msgs;
    }

    public void setLogSuspectedMessages(boolean log_suspected_msgs) {
        this.log_suspected_msgs = log_suspected_msgs;
    }

    @ManagedOperation(description="Print suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Address suspect : this.suspect_history) {
            sb.append(new Date()).append(": ").append(suspect).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation
    public String printCache() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.cache.entrySet()) {
            sb.append(entry.getKey()).append(" has server socket at ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void init() throws Exception {
        this.srv_sock_handler = new ServerSocketHandler();
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        this.stopPingerThread();
        this.stopServerSocket(true);
        this.bcast_task.removeAll();
        this.suspected_mbrs.clear();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_suspect_events = 0;
        this.suspect_history.clear();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FdHeader hdr = (FdHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 10: {
                        if (hdr.mbrs == null) break;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("received SUSPECT message from " + msg.getSrc() + ": suspects=" + hdr.mbrs);
                        }
                        this.suspect(hdr.mbrs);
                        break;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return null;
                        }
                        if (hdr.mbr == null) {
                            return null;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("who-has-sock " + hdr.mbr);
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(msg.getSrc(), this.local_addr, this.srv_sock_addr);
                            return null;
                        }
                        IpAddress addr = (IpAddress)this.cache.get(hdr.mbr);
                        if (addr == null) break;
                        this.sendIHaveSockMessage(msg.getSrc(), hdr.mbr, addr);
                        break;
                    }
                    case 12: {
                        if (hdr.mbr == null || hdr.sock_addr == null) {
                            return null;
                        }
                        this.cache.put(hdr.mbr, hdr.sock_addr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("i-have-sock: " + hdr.mbr + " --> " + hdr.sock_addr + " (cache is " + this.cache + ')');
                        }
                        if (this.ping_dest == null || !hdr.mbr.equals(this.ping_dest)) break;
                        this.ping_addr_promise.setResult(hdr.sock_addr);
                        break;
                    }
                    case 13: {
                        Address sender = msg.getSrc();
                        hdr = new FdHeader(14, new HashMap<Address, IpAddress>(this.cache));
                        msg = new Message(sender, null, null);
                        msg.setFlag(Message.OOB);
                        msg.putHeader(this.id, hdr);
                        this.down_prot.down(new Event(1, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.cachedAddrs == null) {
                            return null;
                        }
                        this.get_cache_promise.setResult(hdr.cachedAddrs);
                    }
                }
                return null;
            }
            case 56: {
                Object val;
                Map config = (Map)evt.getArg();
                if (this.bind_addr == null) {
                    this.bind_addr = (InetAddress)config.get("bind_addr");
                }
                if (this.external_addr == null) {
                    this.external_addr = (InetAddress)config.get("external_addr");
                }
                if (this.external_port > 0 || (val = config.get("external_port")) == null) break;
                this.external_port = (Integer)val;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 51: {
                this.bcast_task.removeSuspectedMember((Address)evt.getArg());
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                Object ret = this.down_prot.down(evt);
                try {
                    this.startServerSocket();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("failed to start server socket", e);
                }
                return ret;
            }
            case 4: {
                this.stopServerSocket(true);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                List<Address> new_mbrs = v.getMembers();
                this.members = new_mbrs;
                this.suspected_mbrs.retainAll(new_mbrs);
                this.cache.keySet().retainAll(new_mbrs);
                this.bcast_task.adjustSuspectedMembers(new_mbrs);
                this.pingable_mbrs.clear();
                this.pingable_mbrs.addAll(new_mbrs);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("VIEW_CHANGE received: " + new_mbrs);
                }
                if (new_mbrs.size() > 1) {
                    if (this.isPingerThreadRunning()) {
                        boolean hasNewPingDest;
                        Address tmp_ping_dest = this.determinePingDest();
                        boolean bl = hasNewPingDest = this.ping_dest != null && tmp_ping_dest != null && !this.ping_dest.equals(tmp_ping_dest);
                        if (!hasNewPingDest) break;
                        this.interruptPingerThread();
                        break;
                    }
                    this.startPingerThread();
                    break;
                }
                this.ping_dest = null;
                this.stopPingerThread();
                break;
            }
            default: {
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public void run() {
        if (!this.srv_sock_sent && this.srv_sock_addr != null) {
            this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
            this.srv_sock_sent = true;
        }
        if (!this.got_cache_from_coord) {
            this.getCacheFromCoordinator();
            this.got_cache_from_coord = true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("pinger_thread started");
        }
        while (this.isPingerThreadRunning()) {
            this.regular_sock_close = false;
            this.ping_dest = this.determinePingDest();
            if (this.log.isDebugEnabled()) {
                this.log.debug("ping_dest is " + this.ping_dest + ", pingable_mbrs=" + this.pingable_mbrs);
            }
            if (this.ping_dest == null || !this.isPingerThreadRunning()) break;
            IpAddress ping_addr = this.fetchPingAddress(this.ping_dest);
            if (ping_addr == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("socket address for " + this.ping_dest + " could not be fetched, retrying");
                }
                Util.sleep(1000L);
                continue;
            }
            if (!this.setupPingSocket(ping_addr) && this.isPingerThreadRunning()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("could not create socket to " + this.ping_dest);
                }
                this.broadcastSuspectMessage(this.ping_dest);
                this.pingable_mbrs.remove(this.ping_dest);
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("ping_dest=" + this.ping_dest + ", ping_sock=" + this.ping_sock + ", cache=" + this.cache);
            }
            try {
                if (this.ping_input == null) continue;
                int c = this.ping_input.read();
                switch (c) {
                    case 9: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("peer " + this.ping_dest + " closed socket gracefully");
                        }
                        this.pingable_mbrs.remove(this.ping_dest);
                        break;
                    }
                    case -1: {
                        this.handleSocketClose(null);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.handleSocketClose(ex);
            }
            catch (Throwable catch_all_the_rest) {
                this.log.error("exception", catch_all_the_rest);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("pinger thread terminated");
        }
    }

    private synchronized boolean isPingerThreadRunning() {
        return this.pinger_thread != null && this.pinger_thread.isAlive() && !this.pinger_thread.isInterrupted();
    }

    void suspect(Set<Address> suspects) {
        Address first;
        if (suspects == null) {
            return;
        }
        ArrayList<Address> eligible_mbrs = new ArrayList<Address>();
        for (Address suspect : suspects) {
            this.suspect_history.add(suspect);
        }
        this.suspected_mbrs.addAll(suspects);
        eligible_mbrs.addAll(this.members);
        eligible_mbrs.removeAll(this.suspected_mbrs);
        if (this.local_addr != null && !eligible_mbrs.isEmpty() && this.local_addr.equals(first = (Address)eligible_mbrs.get(0))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("suspecting " + this.suspected_mbrs);
            }
            for (Address suspect : suspects) {
                this.up_prot.up(new Event(9, suspect));
                this.down_prot.down(new Event(9, suspect));
            }
        }
    }

    void handleSocketClose(Exception ex) {
        this.teardownPingSocket();
        if (!this.regular_sock_close) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("peer " + this.ping_dest + " closed socket (" + (ex != null ? ex.getClass().getName() : "eof") + ')');
            }
            this.broadcastSuspectMessage(this.ping_dest);
            this.pingable_mbrs.remove(this.ping_dest);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("socket to " + this.ping_dest + " was closed gracefully");
            }
            this.regular_sock_close = false;
        }
    }

    private synchronized void startPingerThread() {
        if (!this.isPingerThreadRunning()) {
            ThreadFactory factory = this.getThreadFactory();
            this.pinger_thread = factory.newThread(this, "FD_SOCK pinger");
            this.pinger_thread.setDaemon(true);
            this.pinger_thread.start();
        }
    }

    private void interruptPingerThread() {
        if (this.isPingerThreadRunning()) {
            this.regular_sock_close = true;
            this.teardownPingSocket();
        }
    }

    private synchronized void stopPingerThread() {
        if (this.pinger_thread != null) {
            this.regular_sock_close = true;
            try {
                this.pinger_thread.interrupt();
                this.pinger_thread.join(300L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            this.pinger_thread = null;
        }
        this.ping_addr_promise.setResult(null);
        this.get_cache_promise.setResult(null);
        this.sendPingTermination();
        this.teardownPingSocket();
    }

    void sendPingTermination() {
        this.sendPingSignal(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPingSignal(int signal) {
        Object object = this.sock_mutex;
        synchronized (object) {
            block7: {
                if (this.ping_sock != null) {
                    try {
                        OutputStream out = this.ping_sock.getOutputStream();
                        if (out != null) {
                            out.write(signal);
                            out.flush();
                        }
                    }
                    catch (Throwable t) {
                        if (!this.log.isTraceEnabled()) break block7;
                        this.log.trace("problem sending signal " + FD_SOCK.signalToString(signal), t);
                    }
                }
            }
        }
    }

    void startServerSocket() throws Exception {
        this.srv_sock = Util.createServerSocket(this.getSocketFactory(), "jgroups.fd_sock.srv_sock", this.bind_addr, this.start_port, this.start_port + this.port_range);
        this.srv_sock_addr = new IpAddress(this.external_addr != null ? this.external_addr : this.bind_addr, this.external_port > 0 ? this.external_port : this.srv_sock.getLocalPort());
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.start();
        }
    }

    public void stopServerSocket(boolean graceful) {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.stop(graceful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setupPingSocket(IpAddress dest) {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (dest == null) {
                return false;
            }
            try {
                InetSocketAddress destAddr = new InetSocketAddress(dest.getIpAddress(), dest.getPort());
                this.ping_sock = this.getSocketFactory().createSocket("jgroups.fd.ping_sock");
                int num_bind_attempts = 0;
                int port = this.client_bind_port;
                while (true) {
                    try {
                        this.ping_sock.bind(new InetSocketAddress(this.bind_addr, port));
                    }
                    catch (IOException e) {
                        if (num_bind_attempts++ > this.port_range) {
                            this.log.error("failed creating client socket to " + dest, e);
                            throw e;
                        }
                        ++port;
                        continue;
                    }
                    break;
                }
                this.ping_sock.setSoLinger(true, 1);
                this.ping_sock.setKeepAlive(this.keep_alive);
                Util.connect(this.ping_sock, destAddr, this.sock_conn_timeout);
                this.ping_input = this.ping_sock.getInputStream();
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void teardownPingSocket() {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (this.ping_sock != null) {
                try {
                    this.ping_sock.shutdownInput();
                    this.ping_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ping_sock = null;
            }
            Util.close(this.ping_input);
            this.ping_input = null;
        }
    }

    void getCacheFromCoordinator() {
        this.get_cache_promise.reset();
        for (int attempts = this.num_tries; attempts > 0 && this.isPingerThreadRunning(); --attempts) {
            Address coord = this.determineCoordinator();
            if (coord == null) continue;
            if (coord.equals(this.local_addr)) {
                return;
            }
            FdHeader hdr = new FdHeader(13);
            Message msg = new Message(coord, null, null);
            msg.setFlag(Message.OOB);
            msg.putHeader(this.id, hdr);
            this.down_prot.down(new Event(1, msg));
            Map<Address, IpAddress> result = this.get_cache_promise.getResult(this.get_cache_timeout);
            if (result == null) continue;
            this.cache.putAll(result);
            if (this.log.isTraceEnabled()) {
                this.log.trace("got cache from " + coord + ": cache is " + this.cache);
            }
            return;
        }
    }

    void broadcastSuspectMessage(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("suspecting " + suspected_mbr + " (own address is " + this.local_addr + ')');
        }
        FdHeader hdr = new FdHeader(10);
        hdr.mbrs = new HashSet<Address>(1);
        hdr.mbrs.add(suspected_mbr);
        Message suspect_msg = new Message();
        suspect_msg.setFlag(Message.OOB);
        suspect_msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, suspect_msg));
        this.bcast_task.addSuspectedMember(suspected_mbr);
        if (this.stats) {
            ++this.num_suspect_events;
            this.suspect_history.add(suspected_mbr);
        }
    }

    void sendIHaveSockMessage(Address dst, Address mbr, IpAddress addr) {
        Message msg = new Message(dst, null, null);
        msg.setFlag(Message.OOB);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.sock_addr = addr;
        msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, msg));
    }

    private IpAddress fetchPingAddress(Address mbr) {
        if (mbr == null) {
            return null;
        }
        IpAddress ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        if (!this.isPingerThreadRunning()) {
            return null;
        }
        this.ping_addr_promise.reset();
        Message ping_addr_req = new Message(mbr, null, null);
        ping_addr_req.setFlag(Message.OOB);
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, ping_addr_req));
        ret = this.ping_addr_promise.getResult(500L);
        if (ret != null) {
            return ret;
        }
        if (!this.isPingerThreadRunning()) {
            return null;
        }
        ping_addr_req = new Message(null);
        ping_addr_req.setFlag(Message.OOB);
        hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, ping_addr_req));
        ret = this.ping_addr_promise.getResult(500L);
        return ret;
    }

    private Address determinePingDest() {
        Address first_mbr = null;
        boolean several_mbrs = false;
        boolean found_local_addr = false;
        if (this.pingable_mbrs == null || this.local_addr == null) {
            return null;
        }
        for (Address tmp : this.pingable_mbrs) {
            if (found_local_addr) {
                return tmp;
            }
            if (first_mbr == null) {
                first_mbr = tmp;
            } else {
                several_mbrs = true;
            }
            if (!tmp.equals(this.local_addr)) continue;
            found_local_addr = true;
        }
        if (found_local_addr && several_mbrs) {
            return first_mbr;
        }
        return null;
    }

    protected Address determineCoordinator() {
        List<Address> tmp = this.members;
        return !tmp.isEmpty() ? tmp.get(0) : null;
    }

    static String signalToString(int signal) {
        switch (signal) {
            case 9: {
                return "NORMAL_TERMINATION";
            }
            case -1: {
                return "ABNORMAL_TERMINATION";
            }
        }
        return "n/a";
    }

    private class BroadcastTask
    implements Runnable {
        final Set<Address> suspects = new HashSet<Address>();
        Future<?> future;

        private BroadcastTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD_SOCK.this.members.contains(mbr)) {
                return;
            }
            Set<Address> set = this.suspects;
            synchronized (set) {
                if (this.suspects.add(mbr)) {
                    this.startTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            Set<Address> set = this.suspects;
            synchronized (set) {
                this.suspects.remove(suspected_mbr);
                if (this.suspects.isEmpty()) {
                    this.stopTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Set<Address> set = this.suspects;
            synchronized (set) {
                this.suspects.clear();
                this.stopTask();
            }
        }

        private void startTask() {
            block3: {
                if (this.future == null || this.future.isDone()) {
                    try {
                        this.future = FD_SOCK.this.timer.scheduleWithFixedDelay(this, FD_SOCK.this.suspect_msg_interval, FD_SOCK.this.suspect_msg_interval, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException e) {
                        if (!FD_SOCK.this.log.isWarnEnabled()) break block3;
                        FD_SOCK.this.log.warn("task " + this + " was rejected as timer thread pool is shutting down");
                    }
                }
            }
        }

        private void stopTask() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustSuspectedMembers(List<Address> new_mbrship) {
            if (new_mbrship == null || new_mbrship.isEmpty()) {
                return;
            }
            Set<Address> set = this.suspects;
            synchronized (set) {
                boolean modified = this.suspects.retainAll(new_mbrship);
                if (FD_SOCK.this.log.isTraceEnabled() && modified) {
                    FD_SOCK.this.log.trace("adjusted suspected_mbrs: " + this.suspects);
                }
                if (this.suspects.isEmpty()) {
                    this.stopTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            if (FD_SOCK.this.log.isTraceEnabled()) {
                FD_SOCK.this.log.trace("broadcasting SUSPECT message (suspected_mbrs=" + this.suspects + ") to group");
            }
            Set<Address> set = this.suspects;
            synchronized (set) {
                if (this.suspects.isEmpty()) {
                    this.stopTask();
                    if (FD_SOCK.this.log.isTraceEnabled()) {
                        FD_SOCK.this.log.trace("task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(10);
                hdr.mbrs = new HashSet<Address>(this.suspects);
            }
            Message suspect_msg = new Message();
            suspect_msg.setFlag(Message.OOB);
            suspect_msg.putHeader(FD_SOCK.this.id, hdr);
            FD_SOCK.this.down_prot.down(new Event(1, suspect_msg));
            if (FD_SOCK.this.log.isTraceEnabled()) {
                FD_SOCK.this.log.trace("task done");
            }
        }
    }

    private static class ClientConnectionHandler
    implements Runnable {
        Socket client_sock = null;
        InputStream in;
        final Object mutex = new Object();
        final List<ClientConnectionHandler> clients;

        ClientConnectionHandler(Socket client_sock, List<ClientConnectionHandler> clients) {
            this.client_sock = client_sock;
            this.clients = clients;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread(boolean graceful) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.client_sock != null) {
                    try {
                        if (graceful) {
                            OutputStream out = this.client_sock.getOutputStream();
                            out.write(9);
                            out.flush();
                        }
                        this.closeClientSocket();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeClientSocket() {
            Object object = this.mutex;
            synchronized (object) {
                Util.close(this.client_sock);
                this.client_sock = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int b;
                Object object = this.mutex;
                synchronized (object) {
                    block25: {
                        if (this.client_sock != null) break block25;
                        return;
                    }
                    this.in = this.client_sock.getInputStream();
                }
                while ((b = this.in.read()) != -1 && b != 9) {
                }
            }
            catch (IOException ex) {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                List<ClientConnectionHandler> list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
            finally {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                List<ClientConnectionHandler> list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
        }
    }

    private class ServerSocketHandler
    implements Runnable {
        Thread acceptor = null;
        final List<ClientConnectionHandler> clients = new LinkedList<ClientConnectionHandler>();

        String getName() {
            return this.acceptor != null ? this.acceptor.getName() : null;
        }

        ServerSocketHandler() {
            this.start();
        }

        final void start() {
            if (this.acceptor == null) {
                this.acceptor = FD_SOCK.this.getThreadFactory().newThread(this, "FD_SOCK server socket acceptor");
                this.acceptor.setDaemon(true);
                this.acceptor.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void stop(boolean graceful) {
            if (this.acceptor != null && this.acceptor.isAlive()) {
                try {
                    FD_SOCK.this.getSocketFactory().close(FD_SOCK.this.srv_sock);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List<ClientConnectionHandler> list = this.clients;
            synchronized (list) {
                for (ClientConnectionHandler handler : this.clients) {
                    handler.stopThread(graceful);
                }
                this.clients.clear();
            }
            this.acceptor = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.acceptor != null && FD_SOCK.this.srv_sock != null) {
                try {
                    if (FD_SOCK.this.log.isTraceEnabled()) {
                        FD_SOCK.this.log.trace("waiting for client connections on " + FD_SOCK.this.srv_sock.getInetAddress() + ":" + FD_SOCK.this.srv_sock.getLocalPort());
                    }
                    Socket client_sock = FD_SOCK.this.srv_sock.accept();
                    if (FD_SOCK.this.log.isTraceEnabled()) {
                        FD_SOCK.this.log.trace("accepted connection from " + client_sock.getInetAddress() + ':' + client_sock.getPort());
                    }
                    ClientConnectionHandler client_conn_handler = new ClientConnectionHandler(client_sock, this.clients);
                    Thread t = FD_SOCK.this.getThreadFactory().newThread(client_conn_handler, "FD_SOCK client connection handler");
                    t.setDaemon(true);
                    List<ClientConnectionHandler> list = this.clients;
                    synchronized (list) {
                        this.clients.add(client_conn_handler);
                    }
                    t.start();
                }
                catch (IOException io_ex2) {
                    // empty catch block
                    break;
                }
            }
            this.acceptor = null;
        }
    }

    public static class FdHeader
    extends Header {
        public static final byte SUSPECT = 10;
        public static final byte WHO_HAS_SOCK = 11;
        public static final byte I_HAVE_SOCK = 12;
        public static final byte GET_CACHE = 13;
        public static final byte GET_CACHE_RSP = 14;
        byte type = (byte)10;
        Address mbr = null;
        IpAddress sock_addr;
        Map<Address, IpAddress> cachedAddrs = null;
        Set<Address> mbrs = null;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        public FdHeader(byte type, Address mbr, IpAddress sock_addr) {
            this.type = type;
            this.mbr = mbr;
            this.sock_addr = sock_addr;
        }

        public FdHeader(byte type, Set<Address> mbrs) {
            this.type = type;
            this.mbrs = mbrs;
        }

        public FdHeader(byte type, Map<Address, IpAddress> cachedAddrs) {
            this.type = type;
            this.cachedAddrs = cachedAddrs;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=").append(this.mbr);
            }
            if (this.sock_addr != null) {
                sb.append(", sock_addr=").append(this.sock_addr);
            }
            if (this.cachedAddrs != null) {
                sb.append(", cache=").append(this.cachedAddrs);
            }
            if (this.mbrs != null) {
                sb.append(", mbrs=").append(this.mbrs);
            }
            return sb.toString();
        }

        public static String type2String(byte type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_SOCK";
                }
                case 12: {
                    return "I_HAVE_SOCK";
                }
                case 13: {
                    return "GET_CACHE";
                }
                case 14: {
                    return "GET_CACHE_RSP";
                }
            }
            return "unknown type (" + type + ')';
        }

        @Override
        public int size() {
            int retval = 1;
            retval += Util.size(this.mbr);
            int ipaddr_size = 0;
            ++ipaddr_size;
            if (this.sock_addr != null) {
                ipaddr_size += this.sock_addr.size();
            }
            retval += ipaddr_size;
            retval += 4;
            if (this.cachedAddrs != null) {
                for (Map.Entry entry : this.cachedAddrs.entrySet()) {
                    Address key = (Address)entry.getKey();
                    if (key != null) {
                        retval += Util.size(key);
                    }
                    ++retval;
                    IpAddress val = (IpAddress)entry.getValue();
                    if (val == null) continue;
                    retval += val.size();
                }
            }
            retval += 4;
            if (this.mbrs != null) {
                for (Address address : this.mbrs) {
                    retval += Util.size(address);
                }
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeAddress(this.mbr, out);
            Util.writeStreamable(this.sock_addr, out);
            int size = this.cachedAddrs != null ? this.cachedAddrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                for (Map.Entry<Address, IpAddress> entry : this.cachedAddrs.entrySet()) {
                    Address key = entry.getKey();
                    IpAddress val = entry.getValue();
                    Util.writeAddress(key, out);
                    Util.writeStreamable(val, out);
                }
            }
            size = this.mbrs != null ? this.mbrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                for (Address address : this.mbrs) {
                    Util.writeAddress(address, out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            int i;
            this.type = in.readByte();
            this.mbr = Util.readAddress(in);
            this.sock_addr = (IpAddress)Util.readStreamable(IpAddress.class, in);
            int size = in.readInt();
            if (size > 0) {
                if (this.cachedAddrs == null) {
                    this.cachedAddrs = new HashMap<Address, IpAddress>(size);
                }
                for (i = 0; i < size; ++i) {
                    Address key = Util.readAddress(in);
                    IpAddress val = (IpAddress)Util.readStreamable(IpAddress.class, in);
                    this.cachedAddrs.put(key, val);
                }
            }
            if ((size = in.readInt()) > 0) {
                if (this.mbrs == null) {
                    this.mbrs = new HashSet<Address>();
                }
                for (i = 0; i < size; ++i) {
                    Address addr = Util.readAddress(in);
                    this.mbrs.add(addr);
                }
            }
        }
    }
}

