/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.jvm;

import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class ClassMapperLite {
    public static final ClassMapperLite INSTANCE;

    @JvmStatic
    @NotNull
    public static final String mapClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        String string = classId.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classId.asString()");
        String internalName = StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null);
        String simpleName2 = StringsKt.removePrefix((String)internalName, (CharSequence)"kotlin/");
        if (Intrinsics.areEqual((Object)simpleName2, (Object)internalName) ^ true) {
            for (JvmPrimitiveType jvmPrimitive : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType;
                PrimitiveType primitiveType2 = primitiveType = jvmPrimitive.getPrimitiveType();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)primitiveType2), (String)"primitiveType");
                if (Intrinsics.areEqual((Object)simpleName2, (Object)primitiveType2.getTypeName().asString())) {
                    String string2 = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jvmPrimitive.desc");
                    return string2;
                }
                if (!Intrinsics.areEqual((Object)simpleName2, (Object)primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual((Object)simpleName2, (Object)KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"classId.asSingleFqName().toUnsafe()");
        ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (javaClassId != null) {
            StringBuilder stringBuilder = new StringBuilder().append("L");
            String string3 = javaClassId.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"javaClassId.asString()");
            return stringBuilder.append(StringsKt.replace$default((String)string3, (char)'.', (char)'$', (boolean)false, (int)4, null)).append(";").toString();
        }
        return 'L' + internalName + ';';
    }

    private ClassMapperLite() {
    }

    static {
        ClassMapperLite classMapperLite;
        INSTANCE = classMapperLite = new ClassMapperLite();
    }
}

