/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import org.jboss.arquillian.junit.AdaptorManager;
import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ArquillianTestClassLifecycleManager
extends AdaptorManager {
    ArquillianTestClassLifecycleManager() {
    }

    @Override
    protected void handleSuiteLevelFailure(Throwable initializationException) {
        throw new RuntimeException("Arquillian initialization has already been attempted, but failed. See previous exceptions for cause", initializationException);
    }

    @Override
    protected void handleBeforeSuiteFailure(Exception e) throws Exception {
        State.runnerFinished();
        if (State.isLastRunner()) {
            State.clean();
        }
        throw e;
    }

    void beforeTestClassPhase(Class<?> testClass) throws Exception {
        State.runnerStarted();
        this.initializeAdaptor();
        if (State.hasTestAdaptor()) {
            this.setAdaptor(State.getTestAdaptor());
        }
        this.getAdaptor().beforeClass(testClass, LifecycleMethodExecutor.NO_OP);
    }

    void afterTestClassPhase(Class<?> testClass) throws Exception {
        this.getAdaptor().afterClass(testClass, LifecycleMethodExecutor.NO_OP);
        this.shutdown(this.getAdaptor());
    }
}

