/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.arquillian.junit.MethodInvoker;
import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.junit.event.AfterRules;
import org.jboss.arquillian.junit.event.BeforeRules;
import org.jboss.arquillian.junit.event.RulesEnrichment;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class ArquillianTest
implements MethodRule {
    private TestRunnerAdaptor adaptor;

    public ArquillianTest() {
        if (!State.hasTestAdaptor()) {
            throw new IllegalStateException("arquillian not initialized. Please make sure to define `ArquillianTestClass` Rule in your testclass. This could be one of the reason for arquillian not to be initialized.");
        }
        this.adaptor = State.getTestAdaptor();
    }

    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                final ArrayList<Throwable> errors = new ArrayList<Throwable>();
                TestClass testClass = new TestClass(method.getDeclaringClass());
                Method testMethod = method.getMethod();
                ArquillianTest.this.adaptor.fireCustomLifecycle((TestLifecycleEvent)new RulesEnrichment(target, testClass, testMethod, LifecycleMethodExecutor.NO_OP));
                ArquillianTest.this.adaptor.fireCustomLifecycle((TestLifecycleEvent)new BeforeRules(target, testClass, base, testMethod, LifecycleMethodExecutor.NO_OP));
                ArquillianTest.this.adaptor.before(target, testMethod, LifecycleMethodExecutor.NO_OP);
                try {
                    new MethodInvoker(){

                        void invokeMethod(Object ... parameters) throws Throwable {
                            try {
                                base.evaluate();
                            }
                            catch (Throwable e) {
                                errors.add(e);
                            }
                        }
                    }.invoke(ArquillianTest.this.adaptor, method, target);
                }
                finally {
                    ArquillianTest.this.adaptor.after(target, testMethod, LifecycleMethodExecutor.NO_OP);
                    try {
                        ArquillianTest.this.adaptor.fireCustomLifecycle((TestLifecycleEvent)new AfterRules(target, testMethod, LifecycleMethodExecutor.NO_OP));
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }
}

