/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import org.jboss.arquillian.junit.AdaptorManager;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

abstract class AdaptorManagerWithNotifier
extends AdaptorManager {
    private final RunNotifier notifier;

    AdaptorManagerWithNotifier(RunNotifier notifier) {
        this.notifier = notifier;
    }

    void initializeAdaptor() {
        try {
            super.initializeAdaptor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void prepareDestroyAdaptorProcess() {
        this.notifier.addListener(new RunListener(){

            public void testRunFinished(Result result) throws Exception {
                AdaptorManagerWithNotifier.this.shutdown(AdaptorManagerWithNotifier.this.getAdaptor());
            }
        });
    }

    protected void handleSuiteLevelFailure(Throwable initializationException) {
        this.notifier.fireTestFailure(new Failure(this.getFailureDescription(), (Throwable)new RuntimeException("Arquillian initialization has already been attempted, but failed. See previous exceptions for cause", initializationException)));
    }

    protected void handleBeforeSuiteFailure(Exception e) throws Exception {
        this.notifier.fireTestFailure(new Failure(this.getFailureDescription(), (Throwable)e));
    }

    protected abstract Description getFailureDescription();
}

