/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

public class ComplexDouble {
    private double r;
    private double i;
    public static final ComplexDouble UNIT = new ComplexDouble(1.0, 0.0);
    public static final ComplexDouble I = new ComplexDouble(0.0, 1.0);
    public static final ComplexDouble NEG_UNIT = new ComplexDouble(-1.0, 0.0);
    public static final ComplexDouble NEG_I = new ComplexDouble(0.0, -1.0);
    public static final ComplexDouble ZERO = new ComplexDouble(0.0);

    public ComplexDouble(double real, double imag) {
        this.r = real;
        this.i = imag;
    }

    public ComplexDouble(double real) {
        this(real, 0.0);
    }

    public String toString() {
        if (this.i >= 0.0) {
            return this.r + " + " + this.i + "i";
        }
        return this.r + " - " + -this.i + "i";
    }

    public ComplexDouble set(double real, double imag) {
        this.r = real;
        this.i = imag;
        return this;
    }

    public double real() {
        return this.r;
    }

    public double imag() {
        return this.i;
    }

    public ComplexDouble dup() {
        return new ComplexDouble(this.r, this.i);
    }

    public ComplexDouble copy(ComplexDouble other) {
        this.r = other.r;
        this.i = other.i;
        return this;
    }

    public ComplexDouble addi(ComplexDouble c, ComplexDouble result) {
        if (this == result) {
            this.r += c.r;
            this.i += c.i;
        } else {
            result.r = this.r + c.r;
            result.i = this.i + c.i;
        }
        return result;
    }

    public ComplexDouble addi(ComplexDouble c) {
        return this.addi(c, this);
    }

    public ComplexDouble add(ComplexDouble c) {
        return this.dup().addi(c);
    }

    public ComplexDouble addi(double a, ComplexDouble result) {
        if (this == result) {
            this.r += a;
        } else {
            result.r = this.r + a;
            result.i = this.i;
        }
        return result;
    }

    public ComplexDouble addi(double c) {
        return this.addi(c, this);
    }

    public ComplexDouble add(double c) {
        return this.dup().addi(c);
    }

    public ComplexDouble subi(ComplexDouble c, ComplexDouble result) {
        if (this == result) {
            this.r -= c.r;
            this.i -= c.i;
        } else {
            result.r = this.r - c.r;
            result.i = this.i - c.i;
        }
        return this;
    }

    public ComplexDouble subi(ComplexDouble c) {
        return this.subi(c, this);
    }

    public ComplexDouble sub(ComplexDouble c) {
        return this.dup().subi(c);
    }

    public ComplexDouble subi(double a, ComplexDouble result) {
        if (this == result) {
            this.r -= a;
        } else {
            result.r = this.r - a;
            result.i = this.i;
        }
        return result;
    }

    public ComplexDouble subi(double a) {
        return this.subi(a, this);
    }

    public ComplexDouble sub(double r) {
        return this.dup().subi(r);
    }

    public ComplexDouble muli(ComplexDouble c, ComplexDouble result) {
        double newR = this.r * c.r - this.i * c.i;
        double newI = this.r * c.i + this.i * c.r;
        result.r = newR;
        result.i = newI;
        return result;
    }

    public ComplexDouble muli(ComplexDouble c) {
        return this.muli(c, this);
    }

    public ComplexDouble mul(ComplexDouble c) {
        return this.dup().muli(c);
    }

    public ComplexDouble mul(double v) {
        return this.dup().muli(v);
    }

    public ComplexDouble muli(double v, ComplexDouble result) {
        if (this == result) {
            this.r *= v;
            this.i *= v;
        } else {
            result.r = this.r * v;
            result.i = this.i * v;
        }
        return this;
    }

    public ComplexDouble muli(double v) {
        return this.muli(v, this);
    }

    public ComplexDouble div(ComplexDouble c) {
        return this.dup().divi(c);
    }

    public ComplexDouble divi(ComplexDouble c, ComplexDouble result) {
        double d = c.r * c.r + c.i * c.i;
        double newR = (this.r * c.r + this.i * c.i) / d;
        double newI = (this.i * c.r - this.r * c.i) / d;
        result.r = newR;
        result.i = newI;
        return result;
    }

    public ComplexDouble divi(ComplexDouble c) {
        return this.divi(c, this);
    }

    public ComplexDouble divi(double v, ComplexDouble result) {
        if (this == result) {
            this.r /= v;
            this.i /= v;
        } else {
            result.r = this.r / v;
            result.i = this.i / v;
        }
        return this;
    }

    public ComplexDouble divi(double v) {
        return this.divi(v, this);
    }

    public ComplexDouble div(double v) {
        return this.dup().divi(v);
    }

    public double abs() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public double arg() {
        return Math.atan2(this.i, this.r);
    }

    public ComplexDouble invi() {
        double d = this.r * this.r + this.i * this.i;
        this.r /= d;
        this.i = -this.i / d;
        return this;
    }

    public ComplexDouble inv() {
        return this.dup().invi();
    }

    public ComplexDouble neg() {
        return this.dup().negi();
    }

    public ComplexDouble negi() {
        this.r = -this.r;
        this.i = -this.i;
        return this;
    }

    public ComplexDouble conji() {
        this.i = -this.i;
        return this;
    }

    public ComplexDouble conj() {
        return this.dup().conji();
    }

    public ComplexDouble sqrt() {
        double a = this.abs();
        double s2 = Math.sqrt(2.0);
        double p = Math.sqrt(a + this.r) / s2;
        double sgn = Math.signum(this.i);
        if (sgn == 0.0) {
            sgn = 1.0;
        }
        double q = Math.sqrt(a - this.r) / s2 * Math.signum(sgn);
        return new ComplexDouble(p, q);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComplexDouble)) {
            return false;
        }
        ComplexDouble c = (ComplexDouble)o;
        return this.r == c.r && this.i == c.i;
    }

    public int hashCode() {
        return Double.valueOf(this.r).hashCode() ^ Double.valueOf(this.i).hashCode();
    }

    public boolean eq(ComplexDouble c) {
        return Math.abs(this.r - c.r) + Math.abs(this.i - c.i) < 1.0E-6;
    }

    public boolean ne(ComplexDouble c) {
        return !this.eq(c);
    }

    public boolean isZero() {
        return this.r == 0.0 && this.i == 0.0;
    }

    public boolean isReal() {
        return this.i == 0.0;
    }

    public boolean isImag() {
        return this.r == 0.0;
    }
}

