/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.util.Arrays;
import org.javasimon.CounterSample;
import org.javasimon.Sample;
import org.javasimon.StopwatchSample;
import org.javasimon.utils.SimonUtils;

public class SampleHtmlGenerator {
    private static String lineSeparator = System.getProperty("line.separator");
    private final Iterable<Sample> samples;
    private final StringBuilder builder;

    private SampleHtmlGenerator(Iterable<Sample> samples) {
        this.samples = samples;
        this.builder = new StringBuilder();
    }

    public static String generate(Sample ... samples) {
        return new SampleHtmlGenerator(Arrays.asList(samples)).toHtmlTable();
    }

    public static String generate(Iterable<Sample> samples) {
        return new SampleHtmlGenerator(samples).toHtmlTable();
    }

    private String toHtmlTable() {
        this.buildHeader();
        for (Sample sample : this.samples) {
            this.buildRowForSample(sample);
        }
        this.builder.append("</table>");
        return this.builder.toString();
    }

    private void buildHeader() {
        this.builder.append("<table class=\"javasimon-samples-table\">").append(lineSeparator);
        this.indent(1).append("<tr>").append(lineSeparator);
        this.indent(2).append("<th>Name</th>").append(lineSeparator);
        this.indent(2).append("<th>Active</th>").append(lineSeparator);
        this.indent(2).append("<th>Counter</th>").append(lineSeparator);
        this.indent(2).append("<th>Min</th>").append(lineSeparator);
        this.indent(2).append("<th>Max</th>").append(lineSeparator);
        this.indent(2).append("<th>Mean</th>").append(lineSeparator);
        this.indent(2).append("<th>Total</th>").append(lineSeparator);
        this.indent(1).append("</tr>").append(lineSeparator);
    }

    private void buildRowForSample(Sample sample) {
        this.indent(1).append("<tr>").append(lineSeparator);
        this.indent(2).append("<td>").append(sample.getName()).append("</td>").append(lineSeparator);
        if (sample instanceof StopwatchSample) {
            StopwatchSample stopwatchSample = (StopwatchSample)sample;
            this.indent(2).append("<td>").append(stopwatchSample.getActive()).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(stopwatchSample.getCounter()).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(SimonUtils.presentMinMaxSplit(stopwatchSample.getMin())).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(SimonUtils.presentMinMaxSplit(stopwatchSample.getMax())).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(SimonUtils.presentNanoTime(stopwatchSample.getMean())).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(SimonUtils.presentNanoTime(stopwatchSample.getTotal())).append("</td>").append(lineSeparator);
        } else {
            CounterSample counterSample = (CounterSample)sample;
            this.indent(2).append("<td>-</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(counterSample.getCounter()).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(SimonUtils.presentMinMaxCount(counterSample.getMin())).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>").append(SimonUtils.presentMinMaxCount(counterSample.getMax())).append("</td>").append(lineSeparator);
            this.indent(2).append("<td>-</td>").append(lineSeparator);
            this.indent(2).append("<td>").append("+").append(SimonUtils.presentMinMaxCount(counterSample.getIncrementSum())).append("/-").append(SimonUtils.presentMinMaxCount(counterSample.getDecrementSum())).append("</td>").append(lineSeparator);
        }
        this.indent(1).append("</tr>").append(lineSeparator);
    }

    private StringBuilder indent(int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.append("    ");
        }
        return this.builder;
    }

    public static void setLineSeparator(String newLineSeparator) {
        lineSeparator = newLineSeparator;
    }
}

