/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.SimonPattern;
import org.javasimon.SimonState;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.jmx.SimonInfo;
import org.javasimon.jmx.SimonManagerMXBean;
import org.javasimon.utils.SimonUtils;

public class SimonManagerMXBeanImpl
implements SimonManagerMXBean {
    private Manager manager;

    public SimonManagerMXBeanImpl(Manager manager) {
        this.manager = manager;
    }

    @Override
    public final void enable() {
        this.manager.enable();
    }

    @Override
    public final void disable() {
        this.manager.disable();
    }

    @Override
    public final boolean isEnabled() {
        return this.manager.isEnabled();
    }

    @Override
    public final String[] getSimonNames() {
        Collection<String> simonNames = this.manager.getSimonNames();
        return simonNames.toArray(new String[simonNames.size()]);
    }

    @Override
    public final String[] getSimonNamesOrdered() {
        Object[] simonNames = this.getSimonNames();
        Arrays.sort(simonNames);
        return simonNames;
    }

    @Override
    public final String getType(String name) {
        Simon s = this.manager.getSimon(name);
        return s != null ? (s instanceof Stopwatch ? "Stopwatch" : "Counter") : null;
    }

    @Override
    public final SimonInfo[] getSimonInfos() {
        String[] simonNames = this.getSimonNamesOrdered();
        SimonInfo[] simonInfo = new SimonInfo[simonNames.length];
        int i = 0;
        for (String name : simonNames) {
            Simon s = this.manager.getSimon(name);
            simonInfo[i++] = new SimonInfo(name, s instanceof Stopwatch ? "Stopwatch" : (s instanceof Counter ? "Counter" : "Unknown"));
        }
        return simonInfo;
    }

    @Override
    public final void clearManager() {
        this.manager.clear();
    }

    @Override
    public final void enableSimon(String name) {
        this.manager.getSimon(name).setState(SimonState.ENABLED, false);
    }

    @Override
    public final void disableSimon(String name) {
        this.manager.getSimon(name).setState(SimonState.DISABLED, false);
    }

    @Override
    public final void inheritState(String name) {
        this.manager.getSimon(name).setState(SimonState.INHERIT, false);
    }

    private org.javasimon.jmx.CounterSample sampleCounter(Simon s) {
        return new org.javasimon.jmx.CounterSample((CounterSample)s.sample());
    }

    @Override
    public final org.javasimon.jmx.CounterSample getCounterSample(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Counter) {
            return this.sampleCounter(s);
        }
        return null;
    }

    @Override
    public final org.javasimon.jmx.CounterSample getCounterSampleAndReset(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Counter) {
            return new org.javasimon.jmx.CounterSample((CounterSample)s.sampleAndReset());
        }
        return null;
    }

    @Override
    public List<org.javasimon.jmx.CounterSample> getCounterSamples(String namePattern) {
        ArrayList<org.javasimon.jmx.CounterSample> counterSamples = new ArrayList<org.javasimon.jmx.CounterSample>();
        for (Simon simon : this.manager.getSimons(SimonPattern.create(namePattern))) {
            if (!(simon instanceof Counter)) continue;
            counterSamples.add(this.sampleCounter(simon));
        }
        return counterSamples;
    }

    @Override
    public List<org.javasimon.jmx.CounterSample> getCounterSamples() {
        return this.getCounterSamples(null);
    }

    private org.javasimon.jmx.StopwatchSample sampleStopwatch(Simon s) {
        return new org.javasimon.jmx.StopwatchSample((StopwatchSample)s.sample());
    }

    @Override
    public final org.javasimon.jmx.StopwatchSample getStopwatchSample(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Stopwatch) {
            return this.sampleStopwatch(s);
        }
        return null;
    }

    @Override
    public final org.javasimon.jmx.StopwatchSample getStopwatchSampleAndReset(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Stopwatch) {
            return new org.javasimon.jmx.StopwatchSample((StopwatchSample)s.sampleAndReset());
        }
        return null;
    }

    @Override
    public List<org.javasimon.jmx.StopwatchSample> getStopwatchSamples(String namePattern) {
        ArrayList<org.javasimon.jmx.StopwatchSample> stopwatchSamples = new ArrayList<org.javasimon.jmx.StopwatchSample>();
        for (Simon simon : this.manager.getSimons(SimonPattern.create(namePattern))) {
            if (!(simon instanceof Stopwatch)) continue;
            stopwatchSamples.add(this.sampleStopwatch(simon));
        }
        return stopwatchSamples;
    }

    @Override
    public List<org.javasimon.jmx.StopwatchSample> getStopwatchSamples() {
        return this.getStopwatchSamples(null);
    }

    @Override
    public final void printSimonTree() {
        System.out.println(SimonUtils.simonTreeString(this.manager.getRootSimon()));
    }

    @Override
    public final void reset(String name) {
        this.manager.getSimon(name).reset();
    }
}

