/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.timeline;

import org.javasimon.callback.timeline.TimeRange;
import org.javasimon.utils.SimonUtils;

public class StopwatchTimeRange
extends TimeRange {
    private long last;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long total;
    private long squareTotal;
    private long counter;

    public StopwatchTimeRange(long startTimestamp, long endTimestamp) {
        super(startTimestamp, endTimestamp);
    }

    public void addSplit(long timestampInMs, long durationInNs) {
        this.last = durationInNs;
        this.total += durationInNs;
        this.squareTotal += durationInNs * durationInNs;
        if (durationInNs > this.max) {
            this.max = durationInNs;
        }
        if (durationInNs < this.min) {
            this.min = durationInNs;
        }
        ++this.counter;
        this.lastTimestamp = timestampInMs;
    }

    public long getLast() {
        return this.last;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getTotal() {
        return this.total;
    }

    public long getCounter() {
        return this.counter;
    }

    private double computeMean() {
        return (double)this.total / (double)this.counter;
    }

    public Double getMean() {
        return this.counter == 0L ? null : Double.valueOf(this.computeMean());
    }

    public Double getVariance() {
        if (this.counter == 0L) {
            return null;
        }
        double mean = this.computeMean();
        double meanSquare = mean * mean;
        double squareMean = (double)this.squareTotal / (double)this.counter;
        return squareMean - meanSquare;
    }

    public Double getStandardDeviation() {
        Double variance = this.getVariance();
        return variance == null ? null : Double.valueOf(Math.sqrt(variance));
    }

    @Override
    protected StringBuilder toStringBuilder(StringBuilder stringBuilder) {
        return super.toStringBuilder(stringBuilder).append(" counter=").append(this.counter).append(" total=").append(SimonUtils.presentNanoTime(this.total)).append(" min=").append(SimonUtils.presentNanoTime(this.min)).append(" mean=").append(SimonUtils.presentNanoTime(this.getMean())).append(" last=").append(SimonUtils.presentNanoTime(this.getLast())).append(" max=").append(SimonUtils.presentNanoTime(this.max)).append(" stddev=").append(SimonUtils.presentNanoTime(this.getStandardDeviation()));
    }
}

