/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.logging;

import org.javasimon.callback.logging.DelegateLogTemplate;
import org.javasimon.callback.logging.LogTemplate;

public class PeriodicLogTemplate<C>
extends DelegateLogTemplate<C> {
    private final long period;
    private long nextTime;

    public PeriodicLogTemplate(LogTemplate delegate, long period) {
        super(delegate);
        this.period = period;
        this.initNextTime();
    }

    public long getNextTime() {
        return this.nextTime;
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private synchronized void initNextTime() {
        this.nextTime = this.getCurrentTime() + this.period;
    }

    public synchronized boolean isNextTimePassed() {
        return this.nextTime < this.getCurrentTime();
    }

    @Override
    public boolean isEnabled(C context) {
        return super.isEnabled(context) && this.isNextTimePassed();
    }

    @Override
    public void log(String message) {
        super.log(message);
        this.initNextTime();
    }
}

