/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.javasimon.callback.logging.LogTemplate;

public class JULLogTemplate<C>
extends LogTemplate<C> {
    private final Logger logger;
    private Level level;

    public JULLogTemplate(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    public JULLogTemplate(String loggerName, Level level) {
        this.logger = Logger.getLogger(loggerName);
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isEnabled(C context) {
        return this.logger.isLoggable(this.level);
    }

    @Override
    public void log(String message) {
        this.logger.log(this.level, message);
    }
}

