/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback;

import java.math.BigDecimal;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.SimonException;
import org.javasimon.SimonPattern;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.utils.Replacer;

public class FilterRule {
    public static final String VAR_SPLIT = "split";
    public static final String VAR_ACTIVE = "active";
    public static final String VAR_MAX_ACTIVE = "maxactive";
    public static final String VAR_COUNTER = "counter";
    public static final String VAR_MAX = "max";
    public static final String VAR_MIN = "min";
    public static final String VAR_TOTAL = "total";
    public static final String VAR_VALUE = "value";
    private static final ScriptEngine ECMA_SCRIPT_ENGINE = new ScriptEngineManager().getEngineByName("ecmascript");
    private static final Replacer[] CONDITION_REPLACERS = new Replacer[]{new Replacer(" lt ", " < ", new Replacer.Modificator[0]), new Replacer(" le ", " <= ", new Replacer.Modificator[0]), new Replacer(" eq ", " == ", new Replacer.Modificator[0]), new Replacer(" ne ", " != ", new Replacer.Modificator[0]), new Replacer(" gt ", " > ", new Replacer.Modificator[0]), new Replacer(" ge ", " >= ", new Replacer.Modificator[0]), new Replacer(" and ", " && ", new Replacer.Modificator[0]), new Replacer(" or ", " || ", new Replacer.Modificator[0]), new Replacer(" not ", " ! ", new Replacer.Modificator[0]), new Replacer("(\\d)s", "$1000000000", new Replacer.Modificator[0]), new Replacer("(\\d)ms", "$1000000", new Replacer.Modificator[0]), new Replacer("(\\d)us", "$1000", new Replacer.Modificator[0])};
    private Type type;
    private String condition;
    private CompiledScript expression;
    private SimonPattern pattern;

    public FilterRule(Type type, String condition, SimonPattern pattern) {
        this.type = type;
        this.condition = condition;
        if (condition != null) {
            condition = condition.toLowerCase();
            for (Replacer conditionReplacer : CONDITION_REPLACERS) {
                condition = conditionReplacer.process(condition);
            }
            try {
                this.expression = ((Compilable)((Object)ECMA_SCRIPT_ENGINE)).compile(condition);
                Bindings bindings = ECMA_SCRIPT_ENGINE.getBindings(100);
                bindings.put(VAR_ACTIVE, (Object)0);
                bindings.put(VAR_COUNTER, (Object)0);
                bindings.put(VAR_MAX, (Object)0);
                bindings.put(VAR_MAX_ACTIVE, (Object)0);
                bindings.put(VAR_MIN, (Object)0);
                bindings.put(VAR_SPLIT, (Object)0);
                bindings.put(VAR_TOTAL, (Object)0);
                bindings.put(VAR_VALUE, (Object)0);
                if (!(this.expression.eval(bindings) instanceof Boolean)) {
                    throw new SimonException("Expression '" + condition + "' does not return boolean.");
                }
            }
            catch (ScriptException e) {
                throw new SimonException(e);
            }
        }
        this.pattern = pattern;
    }

    public Type getType() {
        return this.type;
    }

    public String getCondition() {
        return this.condition;
    }

    public SimonPattern getPattern() {
        return this.pattern;
    }

    public synchronized boolean checkCondition(Simon simon, Object ... params) throws ScriptException {
        if (this.condition == null) {
            return true;
        }
        if (simon instanceof Stopwatch) {
            return this.checkStopwtach((Stopwatch)simon, params);
        }
        if (simon instanceof Counter) {
            return this.checkCounter((Counter)simon, params);
        }
        return true;
    }

    private boolean checkCounter(Counter counter, Object ... params) throws ScriptException {
        Bindings bindings = ECMA_SCRIPT_ENGINE.getBindings(100);
        this.processParams(bindings, params);
        bindings.put(VAR_COUNTER, (Object)counter.getCounter());
        bindings.put(VAR_MAX, (Object)counter.getMax());
        bindings.put(VAR_MIN, (Object)counter.getMin());
        return this.eval(bindings);
    }

    private boolean checkStopwtach(Stopwatch stopwatch, Object ... params) throws ScriptException {
        Bindings bindings = ECMA_SCRIPT_ENGINE.getBindings(100);
        this.processParams(bindings, params);
        bindings.put(VAR_ACTIVE, (Object)stopwatch.getActive());
        bindings.put(VAR_COUNTER, (Object)stopwatch.getCounter());
        bindings.put(VAR_MAX, (Object)stopwatch.getMax());
        bindings.put(VAR_MIN, (Object)stopwatch.getMin());
        bindings.put(VAR_MAX_ACTIVE, (Object)stopwatch.getMaxActive());
        bindings.put(VAR_TOTAL, (Object)stopwatch.getTotal());
        return this.eval(bindings);
    }

    private void processParams(Bindings bindings, Object ... params) {
        for (Object param : params) {
            if (param instanceof Split) {
                bindings.put(VAR_SPLIT, (Object)BigDecimal.valueOf(((Split)param).runningFor()));
                continue;
            }
            if (!(param instanceof Long)) continue;
            bindings.put(VAR_VALUE, (Object)BigDecimal.valueOf((Long)param));
        }
    }

    private boolean eval(Bindings bindings) throws ScriptException {
        return (Boolean)this.expression.eval(bindings);
    }

    public static enum Type {
        MUST,
        SUFFICE,
        MUST_NOT;

    }
}

