/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.script.ScriptException;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Simon;
import org.javasimon.SimonPattern;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.Callback;
import org.javasimon.callback.CompositeCallback;
import org.javasimon.callback.CompositeCallbackImpl;
import org.javasimon.callback.FilterCallback;
import org.javasimon.callback.FilterRule;

public final class CompositeFilterCallback
implements FilterCallback,
CompositeCallback {
    private CompositeCallbackImpl callback = new CompositeCallbackImpl();
    private Map<Callback.Event, List<FilterRule>> rules = new EnumMap<Callback.Event, List<FilterRule>>(Callback.Event.class);

    public CompositeFilterCallback() {
        for (Callback.Event event : Callback.Event.values()) {
            this.rules.put(event, new CopyOnWriteArrayList());
        }
    }

    @Override
    public List<Callback> callbacks() {
        return this.callback.callbacks();
    }

    @Override
    public void addCallback(Callback callback) {
        this.callback.addCallback(callback);
    }

    @Override
    public void removeCallback(Callback callback) {
        this.callback.removeCallback(callback);
    }

    @Override
    public void removeAllCallbacks() {
        this.callback.removeAllCallbacks();
    }

    @Override
    public void initialize() {
        this.callback.initialize();
    }

    @Override
    public void cleanup() {
        this.callback.cleanup();
    }

    @Override
    public void onSimonReset(Simon simon) {
        if (this.rulesApplyTo(simon, Callback.Event.RESET, new Object[0])) {
            this.callback.onSimonReset(simon);
        }
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, long ns, StopwatchSample sample) {
        if (this.rulesApplyTo(stopwatch, Callback.Event.STOPWATCH_ADD, ns)) {
            this.callback.onStopwatchAdd(stopwatch, ns, sample);
        }
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        if (this.rulesApplyTo(stopwatch, Callback.Event.STOPWATCH_ADD, split.runningFor())) {
            this.callback.onStopwatchAdd(stopwatch, split, sample);
        }
    }

    @Override
    public void onStopwatchStart(Split split) {
        if (this.rulesApplyTo(split.getStopwatch(), Callback.Event.STOPWATCH_START, split)) {
            this.callback.onStopwatchStart(split);
        }
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        if (this.rulesApplyTo(split.getStopwatch(), Callback.Event.STOPWATCH_STOP, split)) {
            this.callback.onStopwatchStop(split, sample);
        }
    }

    @Override
    public void onCounterDecrease(Counter counter, long dec, CounterSample sample) {
        if (this.rulesApplyTo(counter, Callback.Event.COUNTER_DECREASE, dec)) {
            this.callback.onCounterDecrease(counter, dec, sample);
        }
    }

    @Override
    public void onCounterIncrease(Counter counter, long inc, CounterSample sample) {
        if (this.rulesApplyTo(counter, Callback.Event.COUNTER_INCREASE, inc)) {
            this.callback.onCounterIncrease(counter, inc, sample);
        }
    }

    @Override
    public void onCounterSet(Counter counter, long val, CounterSample sample) {
        if (this.rulesApplyTo(counter, Callback.Event.COUNTER_SET, val)) {
            this.callback.onCounterSet(counter, val, sample);
        }
    }

    @Override
    public void onSimonCreated(Simon simon) {
        if (this.rulesApplyTo(simon, Callback.Event.CREATED, new Object[0])) {
            this.callback.onSimonCreated(simon);
        }
    }

    @Override
    public void onSimonDestroyed(Simon simon) {
        if (this.rulesApplyTo(simon, Callback.Event.DESTROYED, new Object[0])) {
            this.callback.onSimonDestroyed(simon);
        }
    }

    @Override
    public void onManagerClear() {
        if (this.rulesApplyTo(null, Callback.Event.MANAGER_CLEAR, new Object[0])) {
            this.callback.onManagerClear();
        }
    }

    @Override
    public void onManagerMessage(String message) {
        if (this.rulesApplyTo(null, Callback.Event.MESSAGE, message)) {
            this.callback.onManagerMessage(message);
        }
    }

    @Override
    public void onManagerWarning(String warning, Exception cause) {
        if (this.rulesApplyTo(null, Callback.Event.WARNING, cause)) {
            this.callback.onManagerWarning(warning, cause);
        }
    }

    @Override
    public void addRule(FilterRule.Type type, String condition, String pattern, Callback.Event ... events) {
        SimonPattern simonPattern = SimonPattern.create(pattern);
        FilterRule rule = new FilterRule(type, condition, simonPattern);
        for (Callback.Event event : events) {
            if (event == null) continue;
            this.rules.get((Object)event).add(rule);
        }
        if (events.length == 0) {
            this.rules.get((Object)Callback.Event.ALL).add(rule);
        }
    }

    private boolean rulesApplyTo(Simon simon, Callback.Event checkedEvent, Object ... params) {
        if (this.rules.get((Object)checkedEvent).size() == 0) {
            return this.checkRules(simon, Callback.Event.ALL, params);
        }
        return this.checkRules(simon, checkedEvent, params);
    }

    private boolean checkRules(Simon simon, Callback.Event event, Object ... params) {
        List<FilterRule> rulesForEvent = this.rules.get((Object)event);
        if (rulesForEvent.size() == 0) {
            return false;
        }
        boolean allMustSatisfied = false;
        for (FilterRule rule : rulesForEvent) {
            boolean result = false;
            try {
                result = this.patternAndConditionCheck(simon, rule, params);
            }
            catch (ScriptException e) {
                this.onManagerWarning("Script exception while evaluating rule expression", e);
            }
            if (!result && rule.getType().equals((Object)FilterRule.Type.MUST)) {
                return false;
            }
            if (result && rule.getType().equals((Object)FilterRule.Type.MUST)) {
                allMustSatisfied = true;
                continue;
            }
            if (result && rule.getType().equals((Object)FilterRule.Type.MUST_NOT)) {
                return false;
            }
            if (!result && rule.getType().equals((Object)FilterRule.Type.MUST_NOT)) {
                allMustSatisfied = true;
                continue;
            }
            if (!result || !rule.getType().equals((Object)FilterRule.Type.SUFFICE)) continue;
            return true;
        }
        return allMustSatisfied;
    }

    private boolean patternAndConditionCheck(Simon simon, FilterRule rule, Object ... params) throws ScriptException {
        if (simon != null && rule.getPattern() != null && !rule.getPattern().matches(simon.getName())) {
            return false;
        }
        return rule.checkCondition(simon, params);
    }
}

