/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback;

import java.util.HashMap;
import java.util.Map;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;

public interface Callback {
    public void initialize();

    public void cleanup();

    public void onStopwatchStart(Split var1);

    public void onStopwatchStop(Split var1, StopwatchSample var2);

    public void onSimonReset(Simon var1);

    public void onStopwatchAdd(Stopwatch var1, long var2, StopwatchSample var4);

    public void onStopwatchAdd(Stopwatch var1, Split var2, StopwatchSample var3);

    public void onCounterDecrease(Counter var1, long var2, CounterSample var4);

    public void onCounterIncrease(Counter var1, long var2, CounterSample var4);

    public void onCounterSet(Counter var1, long var2, CounterSample var4);

    public void onSimonCreated(Simon var1);

    public void onSimonDestroyed(Simon var1);

    public void onManagerClear();

    public void onManagerMessage(String var1);

    public void onManagerWarning(String var1, Exception var2);

    public static enum Event {
        ALL("all"),
        RESET("reset"),
        STOPWATCH_START("start"),
        STOPWATCH_STOP("stop"),
        STOPWATCH_ADD("add"),
        COUNTER_INCREASE("increase"),
        COUNTER_DECREASE("decrease"),
        COUNTER_SET("set"),
        CREATED("created"),
        DESTROYED("destroyed"),
        MANAGER_CLEAR("clearManager"),
        MESSAGE("message"),
        WARNING("warning");

        private static Map<String, Event> codeValues;
        private String code;

        private Event(String code) {
            this.code = code;
        }

        public static Event forCode(String code) {
            return codeValues.get(code);
        }

        static {
            codeValues = new HashMap<String, Event>();
            for (Event value : Event.values()) {
                codeValues.put(value.code, value);
            }
        }
    }
}

