/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.AbstractSimon;
import org.javasimon.Manager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.utils.SimonUtils;

final class StopwatchImpl
extends AbstractSimon
implements Stopwatch {
    private long total;
    private long counter;
    private long active;
    private long max;
    private long maxTimestamp;
    private long maxActive;
    private long maxActiveTimestamp;
    private long min = Long.MAX_VALUE;
    private long minTimestamp;
    private long last;
    private double mean;
    private double mean2;

    StopwatchImpl(String name, Manager manager) {
        super(name, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stopwatch addTime(long ns) {
        StopwatchSample sample = null;
        if (!this.enabled) {
            return this;
        }
        StopwatchImpl stopwatchImpl = this;
        synchronized (stopwatchImpl) {
            this.updateUsages();
            this.addSplit(ns);
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
        }
        this.manager.callback().onStopwatchAdd((Stopwatch)this, ns, sample);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stopwatch addSplit(Split split) {
        if (!this.enabled) {
            return this;
        }
        long splitNs = split.runningFor();
        StopwatchSample sample = null;
        StopwatchImpl stopwatchImpl = this;
        synchronized (stopwatchImpl) {
            this.updateUsages(split.getStart() + splitNs);
            this.addSplit(splitNs);
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
        }
        this.manager.callback().onStopwatchAdd((Stopwatch)this, split, sample);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Split start() {
        if (!this.enabled) {
            return new Split(this);
        }
        long nowNanos = System.nanoTime();
        StopwatchImpl stopwatchImpl = this;
        synchronized (stopwatchImpl) {
            this.updateUsages(nowNanos);
            this.activeStart();
        }
        Split split = new Split(this, nowNanos);
        this.manager.callback().onStopwatchStart(split);
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(Split split, long start, long nowNanos, String subSimon) {
        StopwatchSample sample = null;
        StopwatchImpl stopwatchImpl = this;
        synchronized (stopwatchImpl) {
            --this.active;
            this.updateUsages(nowNanos);
            if (subSimon != null) {
                Stopwatch effectiveStopwatch = this.manager.getStopwatch(this.getName() + "." + subSimon);
                split.setAttribute("effective-stopwatch", effectiveStopwatch);
                effectiveStopwatch.addSplit(split);
                return;
            }
            this.addSplit(nowNanos - start);
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
        }
        this.manager.callback().onStopwatchStop(split, sample);
    }

    private void activeStart() {
        ++this.active;
        if (this.active >= this.maxActive) {
            this.maxActive = this.active;
            this.maxActiveTimestamp = this.getLastUsage();
        }
    }

    @Override
    public synchronized Stopwatch reset() {
        this.total = 0L;
        this.counter = 0L;
        this.max = 0L;
        this.min = Long.MAX_VALUE;
        this.maxTimestamp = 0L;
        this.minTimestamp = 0L;
        this.maxActive = this.active;
        this.maxActiveTimestamp = 0L;
        this.mean = 0.0;
        this.mean2 = 0.0;
        this.resetCommon();
        return this;
    }

    private long addSplit(long split) {
        this.last = split;
        this.total += split;
        ++this.counter;
        if (split > this.max) {
            this.max = split;
            this.maxTimestamp = this.getLastUsage();
        }
        if (split < this.min) {
            this.min = split;
            this.minTimestamp = this.getLastUsage();
        }
        double delta = (double)split - this.mean;
        this.mean = (double)this.total / (double)this.counter;
        this.mean2 += delta * ((double)split - this.mean);
        return split;
    }

    @Override
    public synchronized double getMean() {
        return this.mean;
    }

    @Override
    public synchronized double getVarianceN() {
        if (this.counter == 0L) {
            return 0.0;
        }
        return this.mean2 / (double)this.counter;
    }

    @Override
    public synchronized double getVariance() {
        if (this.counter == 0L) {
            return 0.0;
        }
        long countMinusOne = this.counter - 1L;
        if (this.counter < 2L) {
            countMinusOne = 1L;
        }
        return this.mean2 / (double)countMinusOne;
    }

    @Override
    public synchronized double getStandardDeviation() {
        return Math.sqrt(this.getVarianceN());
    }

    @Override
    public synchronized long getTotal() {
        return this.total;
    }

    @Override
    public synchronized long getLast() {
        return this.last;
    }

    @Override
    public synchronized long getCounter() {
        return this.counter;
    }

    @Override
    public synchronized long getMax() {
        return this.max;
    }

    @Override
    public synchronized long getMin() {
        return this.min;
    }

    @Override
    public synchronized long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    @Override
    public synchronized long getMinTimestamp() {
        return this.minTimestamp;
    }

    @Override
    public synchronized long getActive() {
        return this.active;
    }

    @Override
    public synchronized long getMaxActive() {
        return this.maxActive;
    }

    @Override
    public synchronized long getMaxActiveTimestamp() {
        return this.maxActiveTimestamp;
    }

    @Override
    public synchronized StopwatchSample sampleAndReset() {
        StopwatchSample sample = this.sample();
        this.reset();
        return sample;
    }

    @Override
    public synchronized StopwatchSample sample() {
        StopwatchSample sample = new StopwatchSample();
        sample.setTotal(this.total);
        sample.setCounter(this.counter);
        sample.setMin(this.min);
        sample.setMax(this.max);
        sample.setMinTimestamp(this.minTimestamp);
        sample.setMaxTimestamp(this.maxTimestamp);
        sample.setActive(this.active);
        sample.setMaxActive(this.maxActive);
        sample.setMaxActiveTimestamp(this.maxActiveTimestamp);
        sample.setMean(this.getMean());
        sample.setVariance(this.getVariance());
        sample.setVarianceN(this.getVarianceN());
        sample.setStandardDeviation(this.getStandardDeviation());
        sample.setLast(this.getLast());
        this.sampleCommon(sample);
        return sample;
    }

    private void updateUsages(long nowNanos) {
        this.lastUsage = SimonUtils.millisForNano(nowNanos);
        if (this.firstUsage == 0L) {
            this.firstUsage = this.lastUsage;
        }
    }

    private void updateUsages() {
        this.lastUsage = System.currentTimeMillis();
        if (this.firstUsage == 0L) {
            this.firstUsage = this.lastUsage;
        }
    }

    @Override
    public synchronized String toString() {
        return "Simon Stopwatch: total " + SimonUtils.presentNanoTime(this.total) + ", counter " + this.counter + ", max " + SimonUtils.presentNanoTime(this.max) + ", min " + SimonUtils.presentNanoTime(this.min) + ", mean " + SimonUtils.presentNanoTime((long)this.mean) + super.toString();
    }
}

