/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.AbstractSimon;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.utils.SimonUtils;

final class CounterImpl
extends AbstractSimon
implements Counter {
    private long counter;
    private long incrementSum;
    private long decrementSum;
    private long max = Long.MIN_VALUE;
    private long maxTimestamp;
    private long min = Long.MAX_VALUE;
    private long minTimestamp;

    CounterImpl(String name, Manager manager) {
        super(name, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counter set(long val) {
        if (!this.enabled) {
            return this;
        }
        long now = System.currentTimeMillis();
        CounterSample sample = null;
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.privateSet(val, now);
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
        }
        this.manager.callback().onCounterSet(this, val, sample);
        return this;
    }

    private void privateSet(long val, long now) {
        this.updateUsages(now);
        this.counter = val;
        if (this.counter >= this.max) {
            this.max = this.counter;
            this.maxTimestamp = this.getLastUsage();
        }
        if (this.counter <= this.min) {
            this.min = this.counter;
            this.minTimestamp = this.getLastUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counter increase() {
        if (!this.enabled) {
            return this;
        }
        long now = System.currentTimeMillis();
        CounterSample sample = null;
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.updateUsages(now);
            ++this.counter;
            ++this.incrementSum;
            if (this.counter >= this.max) {
                this.max = this.counter;
                this.maxTimestamp = this.getLastUsage();
            }
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
        }
        this.manager.callback().onCounterIncrease(this, 1L, sample);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counter decrease() {
        if (!this.enabled) {
            return this;
        }
        long now = System.currentTimeMillis();
        CounterSample sample = null;
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.updateUsages(now);
            --this.counter;
            ++this.decrementSum;
            if (this.counter <= this.min) {
                this.min = this.counter;
                this.minTimestamp = this.getLastUsage();
            }
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
        }
        this.manager.callback().onCounterDecrease(this, 1L, sample);
        return this;
    }

    private void updateUsages(long now) {
        this.lastUsage = now;
        if (this.firstUsage == 0L) {
            this.firstUsage = this.lastUsage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counter increase(long inc) {
        CounterSample sample;
        if (!this.enabled) {
            return this;
        }
        long now = System.currentTimeMillis();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.incrementSum += inc;
            this.privateSet(this.counter + inc, now);
            sample = this.sample();
        }
        this.manager.callback().onCounterIncrease(this, inc, sample);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Counter decrease(long dec) {
        CounterSample sample;
        if (!this.enabled) {
            return this;
        }
        long now = System.currentTimeMillis();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            this.decrementSum += dec;
            this.privateSet(this.counter - dec, now);
            sample = this.sample();
        }
        this.manager.callback().onCounterDecrease(this, dec, sample);
        return this;
    }

    @Override
    public synchronized Counter reset() {
        this.counter = 0L;
        this.max = Long.MIN_VALUE;
        this.maxTimestamp = 0L;
        this.min = Long.MAX_VALUE;
        this.minTimestamp = 0L;
        this.incrementSum = 0L;
        this.decrementSum = 0L;
        this.resetCommon();
        return this;
    }

    @Override
    public synchronized CounterSample sampleAndReset() {
        CounterSample sample = this.sample();
        this.reset();
        return sample;
    }

    @Override
    public synchronized CounterSample sample() {
        CounterSample sample = new CounterSample();
        sample.setCounter(this.counter);
        sample.setMin(this.min);
        sample.setMax(this.max);
        sample.setMinTimestamp(this.minTimestamp);
        sample.setMaxTimestamp(this.maxTimestamp);
        sample.setIncrementSum(this.incrementSum);
        sample.setDecrementSum(this.decrementSum);
        this.sampleCommon(sample);
        return sample;
    }

    @Override
    public synchronized long getCounter() {
        return this.counter;
    }

    @Override
    public synchronized long getMin() {
        return this.min;
    }

    @Override
    public synchronized long getMinTimestamp() {
        return this.minTimestamp;
    }

    @Override
    public synchronized long getMax() {
        return this.max;
    }

    @Override
    public synchronized long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    @Override
    public synchronized long getIncrementSum() {
        return this.incrementSum;
    }

    @Override
    public synchronized long getDecrementSum() {
        return this.decrementSum;
    }

    @Override
    public synchronized String toString() {
        return "Simon Counter: counter=" + this.counter + ", max=" + SimonUtils.presentMinMaxCount(this.max) + ", min=" + SimonUtils.presentMinMaxCount(this.min) + super.toString();
    }
}

