/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.NamedPersonImpl;
import org.jasig.services.persondir.support.jdbc.AbstractJdbcPersonAttributeDao;
import org.jasig.services.persondir.support.jdbc.ColumnMapParameterizedRowMapper;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

public class MultiRowJdbcPersonAttributeDao
extends AbstractJdbcPersonAttributeDao<Map<String, Object>> {
    private static final ParameterizedRowMapper<Map<String, Object>> MAPPER = new ColumnMapParameterizedRowMapper();
    private Map<String, Set<String>> nameValueColumnMappings = null;

    public MultiRowJdbcPersonAttributeDao(DataSource ds, String sql) {
        super(ds, sql);
    }

    public Map<String, Set<String>> getNameValueColumnMappings() {
        return this.nameValueColumnMappings;
    }

    public void setNameValueColumnMappings(Map<String, ?> nameValueColumnMap) {
        if (nameValueColumnMap == null) {
            this.nameValueColumnMappings = null;
        } else {
            Map<String, Set<String>> mappings = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(nameValueColumnMap);
            if (mappings.containsValue(null)) {
                throw new IllegalArgumentException("nameValueColumnMap may not have null values");
            }
            this.nameValueColumnMappings = mappings;
        }
    }

    @Override
    protected ParameterizedRowMapper<Map<String, Object>> getRowMapper() {
        return MAPPER;
    }

    @Override
    protected List<IPersonAttributes> parseAttributeMapFromResults(List<Map<String, Object>> queryResults, String queryUserName) {
        Map peopleAttributesBuilder = LazyMap.decorate(new LinkedHashMap(), new LinkedHashMapFactory());
        String userNameAttribute = this.getConfiguredUserNameAttribute();
        for (Map<String, Object> queryResult : queryResults) {
            String userName;
            if (queryUserName != null) {
                userName = queryUserName;
            } else {
                Object userNameValue = queryResult.get(userNameAttribute);
                if (userNameValue == null) {
                    throw new BadSqlGrammarException("No userName column named '" + userNameAttribute + "' exists in result set and no userName provided in query Map", this.getQueryTemplate(), null);
                }
                userName = userNameValue.toString();
            }
            Map attributes = (Map)peopleAttributesBuilder.get(userName);
            for (Map.Entry<String, Set<String>> columnMapping : this.nameValueColumnMappings.entrySet()) {
                String keyColumn = columnMapping.getKey();
                Object attrNameObj = queryResult.get(keyColumn);
                if (attrNameObj == null && !queryResult.containsKey(keyColumn)) {
                    throw new BadSqlGrammarException("No attribute key column named '" + keyColumn + "' exists in result set", this.getQueryTemplate(), null);
                }
                String attrName = String.valueOf(attrNameObj);
                Set<String> valueColumns = columnMapping.getValue();
                ArrayList<Object> attrValues = new ArrayList<Object>(valueColumns.size());
                for (String valueColumn : valueColumns) {
                    Object attrValue = queryResult.get(valueColumn);
                    if (attrValue == null && !queryResult.containsKey(valueColumn)) {
                        throw new BadSqlGrammarException("No attribute value column named '" + valueColumn + "' exists in result set", this.getQueryTemplate(), null);
                    }
                    attrValues.add(attrValue);
                }
                MultivaluedPersonAttributeUtils.addResult(attributes, attrName, attrValues);
            }
        }
        ArrayList<IPersonAttributes> people = new ArrayList<IPersonAttributes>(peopleAttributesBuilder.size());
        for (Map.Entry mappedAttributesEntry : peopleAttributesBuilder.entrySet()) {
            String userName = (String)mappedAttributesEntry.getKey();
            Map attributes = (Map)mappedAttributesEntry.getValue();
            NamedPersonImpl person = new NamedPersonImpl(userName, attributes);
            people.add(person);
        }
        return people;
    }

    private static final class LinkedHashMapFactory<K, V>
    implements Factory {
        private LinkedHashMapFactory() {
        }

        public Map<K, V> create() {
            return new LinkedHashMap();
        }
    }
}

