/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.support.oauth.OAuthConfiguration;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.authentication.principal.OAuthCredentials;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.provider.BaseOAuth10Provider;
import org.scribe.up.provider.BaseOAuthProvider;
import org.scribe.up.provider.OAuthProvider;
import org.scribe.up.session.HttpUserSession;
import org.scribe.up.session.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class OAuthAction
extends AbstractAction {
    private final Logger log = LoggerFactory.getLogger(OAuthAction.class);
    @NotNull
    private OAuthConfiguration configuration;
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    private String oauth10loginUrl = "/oauth10login";

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpSession session = request.getSession();
        String providerType = request.getParameter("oauth_provider");
        this.log.debug("providerType : {}", (Object)providerType);
        if (StringUtils.isNotBlank((String)providerType)) {
            OAuthProvider provider = OAuthUtils.getProviderByType(this.configuration.getProviders(), providerType);
            this.log.debug("provider : {}", (Object)provider);
            OAuthCredential credential = provider.getCredential((UserSession)new HttpUserSession(request), request.getParameterMap());
            this.log.debug("credential : {}", (Object)credential);
            Service service = (Service)session.getAttribute("service");
            context.getFlowScope().put("service", (Object)service);
            this.restoreRequestAttribute(request, session, "theme");
            this.restoreRequestAttribute(request, session, "locale");
            this.restoreRequestAttribute(request, session, "method");
            OAuthCredentials credentials = new OAuthCredentials(credential);
            try {
                WebUtils.putTicketGrantingTicketInRequestScope((RequestContext)context, (String)this.centralAuthenticationService.createTicketGrantingTicket((Credentials)credentials));
                return this.success();
            }
            catch (TicketException ticketException) {
                return this.error();
            }
        }
        Service service = (Service)context.getFlowScope().get("service");
        if (service != null) {
            session.setAttribute("service", (Object)service);
        }
        this.saveRequestParameter(request, session, "theme");
        this.saveRequestParameter(request, session, "locale");
        this.saveRequestParameter(request, session, "method");
        for (OAuthProvider provider : this.configuration.getProviders()) {
            String key = String.valueOf(provider.getType()) + "Url";
            String authorizationUrl = null;
            authorizationUrl = provider instanceof BaseOAuth10Provider ? OAuthUtils.addParameter(String.valueOf(request.getContextPath()) + this.oauth10loginUrl, "oauth_provider", provider.getType()) : provider.getAuthorizationUrl((UserSession)new HttpUserSession(session));
            this.log.debug("{} -> {}", (Object)key, (Object)authorizationUrl);
            context.getFlowScope().put(key, (Object)authorizationUrl);
        }
        return this.error();
    }

    private void restoreRequestAttribute(HttpServletRequest request, HttpSession session, String name) {
        String value = (String)session.getAttribute(name);
        request.setAttribute(name, (Object)value);
    }

    private void saveRequestParameter(HttpServletRequest request, HttpSession session, String name) {
        String value = request.getParameter(name);
        if (value != null) {
            session.setAttribute(name, (Object)value);
        }
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setOauth10loginUrl(String oauth10loginUrl) {
        this.oauth10loginUrl = oauth10loginUrl;
    }

    public void setConfiguration(OAuthConfiguration configuration) {
        this.configuration = configuration;
        for (OAuthProvider provider : configuration.getProviders()) {
            BaseOAuthProvider baseProvider = (BaseOAuthProvider)provider;
            baseProvider.setCallbackUrl(OAuthUtils.addParameter(configuration.getLoginUrl(), "oauth_provider", provider.getType()));
        }
    }
}

