/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20AccessTokenController
extends AbstractController {
    private static Logger log = LoggerFactory.getLogger(OAuth20AccessTokenController.class);
    private final ServicesManager servicesManager;
    private final TicketRegistry ticketRegistry;
    private final long timeout;

    public OAuth20AccessTokenController(ServicesManager servicesManager, TicketRegistry ticketRegistry, long timeout) {
        this.servicesManager = servicesManager;
        this.ticketRegistry = ticketRegistry;
        this.timeout = timeout;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String redirectUri = request.getParameter("redirect_uri");
        log.debug("redirect_uri : {}", (Object)redirectUri);
        String clientId = request.getParameter("client_id");
        log.debug("clientId : {}", (Object)clientId);
        String clientSecret = request.getParameter("client_secret");
        log.debug("clientSecret : {}", (Object)clientSecret);
        String code = request.getParameter("code");
        log.debug("code : {}", (Object)clientSecret);
        if (StringUtils.isBlank((String)clientId)) {
            log.error("missing clientId");
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        if (StringUtils.isBlank((String)redirectUri)) {
            log.error("missing redirectUri");
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        if (StringUtils.isBlank((String)clientSecret)) {
            log.error("missing clientSecret");
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        if (StringUtils.isBlank((String)code)) {
            log.error("missing code");
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        Collection services = this.servicesManager.getAllServices();
        RegisteredService service = null;
        for (RegisteredService aService : services) {
            if (!StringUtils.equals((String)aService.getName(), (String)clientId)) continue;
            service = aService;
            break;
        }
        if (service == null) {
            log.error("Unknown clientId : {}", (Object)clientId);
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        String serviceId = service.getServiceId();
        if (!StringUtils.startsWith((String)redirectUri, (String)serviceId)) {
            log.error("Unsupported redirectUri : {} for serviceId : {}", (Object)redirectUri, (Object)serviceId);
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        String serviceDescription = service.getDescription();
        if (!StringUtils.equals((String)serviceDescription, (String)clientSecret)) {
            log.error("Wrong client secret : {} for service description : {}", (Object)clientSecret, (Object)serviceDescription);
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(code);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            log.error("Code expired : {}", (Object)code);
            return OAuthUtils.writeTextError(response, "invalid_grant", 400);
        }
        TicketGrantingTicket ticketGrantingTicket = serviceTicket.getGrantingTicket();
        this.ticketRegistry.deleteTicket(serviceTicket.getId());
        response.setContentType("text/plain");
        int expires = (int)(this.timeout - (System.currentTimeMillis() - ticketGrantingTicket.getCreationTime()) / 1000L);
        String text = "access_token=" + ticketGrantingTicket.getId() + "&expires=" + expires;
        log.debug("text : {}", (Object)text);
        return OAuthUtils.writeText(response, text, 200);
    }

    static void setLogger(Logger aLogger) {
        log = aLogger;
    }
}

