/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReturnAllowedAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    private static final long serialVersionUID = -5771481877391140569L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnAllowedAttributeReleasePolicy.class);
    private List<String> allowedAttributes;

    public ReturnAllowedAttributeReleasePolicy() {
        this(new ArrayList<String>());
    }

    public ReturnAllowedAttributeReleasePolicy(List<String> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    public void setAllowedAttributes(List<String> allowed) {
        this.allowedAttributes = allowed;
    }

    public List<String> getAllowedAttributes() {
        return Collections.unmodifiableList(this.allowedAttributes);
    }

    @Override
    protected Map<String, Object> getAttributesInternal(Map<String, Object> resolvedAttributes) {
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>(resolvedAttributes.size());
        for (String attribute : this.allowedAttributes) {
            Object value = resolvedAttributes.get(attribute);
            if (value == null) continue;
            LOGGER.debug("Found attribute [{}] in the list of allowed attributes", (Object)attribute);
            attributesToRelease.put(attribute, value);
        }
        return attributesToRelease;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReturnAllowedAttributeReleasePolicy rhs = (ReturnAllowedAttributeReleasePolicy)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.allowedAttributes, rhs.allowedAttributes).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(13, 133).appendSuper(super.hashCode()).append(this.allowedAttributes).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("allowedAttributes", this.allowedAttributes).toString();
    }
}

