/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal.cache;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.util.ApplicationContextProvider;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.jasig.services.persondir.support.merger.NoncollidingAttributeAdder;
import org.jasig.services.persondir.support.merger.ReplacingAttributeAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractPrincipalAttributesRepository
implements PrincipalAttributesRepository,
Closeable {
    private static final TimeUnit DEFAULT_CACHE_EXPIRATION_UNIT = TimeUnit.HOURS;
    private static final long DEFAULT_CACHE_EXPIRATION_DURATION = 2L;
    private static final long serialVersionUID = 6350245643948535906L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPrincipalAttributesRepository.class);
    protected final long expiration;
    protected final TimeUnit timeUnit;
    protected MergingStrategy mergingStrategy;
    private transient IPersonAttributeDao attributeRepository;

    protected AbstractPrincipalAttributesRepository() {
        this(2L, DEFAULT_CACHE_EXPIRATION_UNIT);
    }

    public AbstractPrincipalAttributesRepository(long expiration, TimeUnit timeUnit) {
        this.expiration = expiration;
        this.timeUnit = timeUnit;
    }

    public final void setMergingStrategy(MergingStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy;
    }

    public final MergingStrategy getMergingStrategy() {
        return this.mergingStrategy;
    }

    protected final Map<String, Object> convertPersonAttributesToPrincipalAttributes(Map<String, List<Object>> attributes) {
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        Iterator<Map.Entry<String, List<Object>>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            List<Object> values;
            Map.Entry<String, List<Object>> entry;
            convertedAttributes.put(entry.getKey(), (values = (entry = iterator.next()).getValue()).size() == 1 ? values.get(0) : values);
        }
        return convertedAttributes;
    }

    private Map<String, List<Object>> convertPrincipalAttributesToPersonAttributes(Principal p) {
        HashMap<String, List<Object>> convertedAttributes = new HashMap<String, List<Object>>(p.getAttributes().size());
        Map principalAttributes = p.getAttributes();
        for (Map.Entry entry : principalAttributes.entrySet()) {
            Object values = entry.getValue();
            String key = (String)entry.getKey();
            if (values instanceof List) {
                convertedAttributes.put(key, (List)values);
                continue;
            }
            convertedAttributes.put(key, Collections.singletonList(values));
        }
        return convertedAttributes;
    }

    protected final Map<String, List<Object>> retrievePersonAttributesToPrincipalAttributes(String id) {
        IPersonAttributes attrs = this.getAttributeRepository().getPerson(id);
        if (attrs == null) {
            LOGGER.debug("Could not find principal [{}] in the repository so no attributes are returned.", (Object)id);
            return Collections.emptyMap();
        }
        Map attributes = attrs.getAttributes();
        if (attributes == null) {
            LOGGER.debug("Principal [{}] has no attributes and so none are returned.", (Object)id);
            return Collections.emptyMap();
        }
        return attributes;
    }

    public final Map<String, Object> getAttributes(Principal p) {
        Map<String, Object> cachedAttributes = this.getPrincipalAttributes(p);
        if (cachedAttributes != null && !cachedAttributes.isEmpty()) {
            LOGGER.debug("Found [{}] cached attributes for principal [{}]", (Object)cachedAttributes.size(), (Object)p.getId());
            return cachedAttributes;
        }
        if (this.getAttributeRepository() == null) {
            LOGGER.debug("No attribute repository is defined for [{}]. Returning default principal attributes for {}", (Object)this.getClass().getName(), (Object)p.getId());
            return cachedAttributes;
        }
        Map<String, List<Object>> sourceAttributes = this.retrievePersonAttributesToPrincipalAttributes(p.getId());
        LOGGER.debug("Found [{}] attributes for principal [{}] from the attribute repository.", (Object)sourceAttributes.size(), (Object)p.getId());
        if (this.mergingStrategy == null || this.mergingStrategy.getAttributeMerger() == null) {
            LOGGER.debug("No merging strategy found, so attributes retrieved from the repository will be used instead.");
            return this.convertAttributesToPrincipalAttributesAndCache(p, sourceAttributes);
        }
        Map<String, List<Object>> principalAttributes = this.convertPrincipalAttributesToPersonAttributes(p);
        LOGGER.debug("Merging current principal attributes with that of the repository via strategy [{}]", (Object)((Object)((Object)this.mergingStrategy)).getClass().getSimpleName());
        Map mergedAttributes = this.mergingStrategy.getAttributeMerger().mergeAttributes(principalAttributes, sourceAttributes);
        return this.convertAttributesToPrincipalAttributesAndCache(p, mergedAttributes);
    }

    private Map<String, Object> convertAttributesToPrincipalAttributesAndCache(Principal p, Map<String, List<Object>> sourceAttributes) {
        Map<String, Object> finalAttributes = this.convertPersonAttributesToPrincipalAttributes(sourceAttributes);
        this.addPrincipalAttributes(p.getId(), finalAttributes);
        return finalAttributes;
    }

    protected abstract void addPrincipalAttributes(String var1, Map<String, Object> var2);

    protected abstract Map<String, Object> getPrincipalAttributes(Principal var1);

    public void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    private IPersonAttributeDao getAttributeRepository() {
        if (this.attributeRepository == null) {
            ApplicationContext context = ApplicationContextProvider.getApplicationContext();
            if (context != null) {
                return (IPersonAttributeDao)context.getBean("attributeRepository", IPersonAttributeDao.class);
            }
            LOGGER.warn("No application context could be retrieved, so no attribute repository instance can be determined.");
        }
        return this.attributeRepository;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("mergingStrategy", (Object)this.mergingStrategy).append("expiration", this.expiration).append("timeUnit", (Object)this.timeUnit).toString();
    }

    public long getExpiration() {
        return this.expiration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractPrincipalAttributesRepository rhs = (AbstractPrincipalAttributesRepository)obj;
        return new EqualsBuilder().append((Object)this.timeUnit, (Object)rhs.timeUnit).append(this.expiration, rhs.expiration).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 133).append((Object)this.timeUnit).append(this.expiration).toHashCode();
    }

    public static enum MergingStrategy {
        REPLACE,
        ADD,
        NONE,
        MULTIVALUED;


        public IAttributeMerger getAttributeMerger() {
            String name = this.name().toUpperCase();
            switch (name.toUpperCase()) {
                case "REPLACE": {
                    return new ReplacingAttributeAdder();
                }
                case "ADD": {
                    return new NoncollidingAttributeAdder();
                }
                case "MULTIVALUED": {
                    return new MultivaluedAttributeMerger();
                }
            }
            return null;
        }
    }
}

