/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="defaultPasswordEncoder")
public final class DefaultPasswordEncoder
implements PasswordEncoder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int HEX_RIGHT_SHIFT_COEFFICIENT = 4;
    private static final int HEX_HIGH_BITS_BITWISE_FLAG = 15;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPasswordEncoder.class);
    private final String encodingAlgorithm;
    @Value(value="${cas.authn.password.encoding.char:}")
    private String characterEncoding;

    @Autowired
    public DefaultPasswordEncoder(@Value(value="${cas.authn.password.encoding.alg:}") String encodingAlgorithm) {
        this.encodingAlgorithm = encodingAlgorithm;
    }

    public String encode(String password) {
        if (password == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.encodingAlgorithm)) {
            LOGGER.warn("No encoding algorithm is defined. Password cannot be encoded; Returning null");
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.encodingAlgorithm);
            String encodingCharToUse = StringUtils.isNotBlank((CharSequence)this.characterEncoding) ? this.characterEncoding : Charset.defaultCharset().name();
            LOGGER.warn("Using {} as the character encoding algorithm to update the digest", (Object)encodingCharToUse);
            messageDigest.update(password.getBytes(encodingCharToUse));
            byte[] digest = messageDigest.digest();
            return DefaultPasswordEncoder.getFormattedText(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        int j = 0;
        while (j < bytes.length) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
            ++j;
        }
        return buf.toString();
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }
}

