/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="requiredHandlerAuthenticationPolicy")
public class RequiredHandlerAuthenticationPolicy
implements AuthenticationPolicy {
    @NotNull
    private final String requiredHandlerName;
    private boolean tryAll;

    @Autowired
    public RequiredHandlerAuthenticationPolicy(@Value(value="${cas.authn.policy.req.handlername:handlerName}") String requiredHandlerName) {
        this.requiredHandlerName = requiredHandlerName;
    }

    @Autowired
    public void setTryAll(@Value(value="${cas.authn.policy.req.tryall:false}") boolean tryAll) {
        this.tryAll = tryAll;
    }

    public boolean isSatisfiedBy(Authentication authn) {
        boolean credsOk = true;
        if (this.tryAll) {
            boolean bl = credsOk = authn.getCredentials().size() == authn.getSuccesses().size() + authn.getFailures().size();
        }
        return credsOk && StringUtils.isNotBlank((CharSequence)this.requiredHandlerName) && authn.getSuccesses().containsKey(this.requiredHandlerName);
    }
}

