/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.AuthenticationTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="defaultAuthenticationTransactionManager")
public class DefaultAuthenticationTransactionManager
implements AuthenticationTransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticationTransactionManager.class);
    @Autowired
    @Qualifier(value="authenticationManager")
    private AuthenticationManager authenticationManager;

    public AuthenticationTransactionManager handle(AuthenticationTransaction authenticationTransaction, AuthenticationContextBuilder authenticationContext) throws AuthenticationException {
        if (!authenticationTransaction.getCredentials().isEmpty()) {
            Authentication authentication = this.authenticationManager.authenticate(authenticationTransaction);
            LOGGER.debug("Successful authentication; Collecting authentication result [{}]", (Object)authentication);
            authenticationContext.collect(authentication);
        }
        LOGGER.debug("Transaction ignored since there are no credentials to authenticate");
        return this;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

